/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWordWrap;
import com.google.gwt.user.client.ui.RootPanel;

public class Anchor
extends FocusWidget
implements HasHorizontalAlignment,
HasName,
HasText,
HasHTML,
HasWordWrap,
HasDirection {
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign;

    public static Anchor wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        Anchor anchor = new Anchor(element);
        anchor.onAttach();
        RootPanel.detachOnWindowClose(anchor);
        return anchor;
    }

    public Anchor() {
        this.setElement(Document.get().createAnchorElement());
        this.setStyleName("gwt-Anchor");
    }

    public Anchor(String text) {
        this(text, "javascript:");
    }

    public Anchor(String text, boolean asHtml) {
        this(text, asHtml, "javascript:");
    }

    public Anchor(String text, boolean asHTML, String href) {
        this();
        if (asHTML) {
            this.setHTML(text);
        } else {
            this.setText(text);
        }
        this.setHref(href);
    }

    public Anchor(String text, boolean asHtml, String href, String target) {
        this(text, asHtml, href);
        this.setTarget(target);
    }

    public Anchor(String text, String href) {
        this();
        this.setText(text);
        this.setHref(href);
    }

    public Anchor(String text, String href, String target) {
        this(text, false, href, target);
    }

    protected Anchor(Element element) {
        AnchorElement.as(element);
        this.setElement(element);
    }

    public HasDirection.Direction getDirection() {
        return BidiUtils.getDirectionOnElement(this.getElement());
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public String getHref() {
        return this.getAnchorElement().getHref();
    }

    public String getHTML() {
        return this.getElement().getInnerHTML();
    }

    public String getName() {
        return this.getAnchorElement().getName();
    }

    public int getTabIndex() {
        return this.getAnchorElement().getTabIndex();
    }

    public String getTarget() {
        return this.getAnchorElement().getTarget();
    }

    public String getText() {
        return this.getElement().getInnerText();
    }

    public boolean getWordWrap() {
        return !this.getElement().getStyle().getProperty("whiteSpace").equals("nowrap");
    }

    public void setAccessKey(char key) {
        this.getAnchorElement().setAccessKey(Character.toString(key));
    }

    public void setDirection(HasDirection.Direction direction) {
        BidiUtils.setDirectionOnElement(this.getElement(), direction);
    }

    public void setFocus(boolean focused) {
        if (focused) {
            this.getAnchorElement().focus();
        } else {
            this.getAnchorElement().blur();
        }
    }

    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
        this.getElement().getStyle().setProperty("textAlign", align.getTextAlignString());
    }

    public void setHref(String href) {
        this.getAnchorElement().setHref(href);
    }

    public void setHTML(String html) {
        this.getElement().setInnerHTML(html);
    }

    public void setName(String name) {
        this.getAnchorElement().setName(name);
    }

    public void setTabIndex(int index) {
        this.getAnchorElement().setTabIndex(index);
    }

    public void setTarget(String target) {
        this.getAnchorElement().setTarget(target);
    }

    public void setText(String text) {
        this.getElement().setInnerText(text);
    }

    public void setWordWrap(boolean wrap) {
        this.getElement().getStyle().setProperty("whiteSpace", wrap ? "normal" : "nowrap");
    }

    private AnchorElement getAnchorElement() {
        return AnchorElement.as(this.getElement());
    }
}

