package com.extjs.gxt.ui.client.widget;

import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.google.gwt.user.client.DOM;

public class WidgetHelper {
	/**
	 * added by k.taira
	 * 
	 * @return
	 */
	public static String getInternalWidth(BoxComponent comp) {
		if (comp.el() == null) {
			return comp.width;
		}
		int i = comp.getWidth();
		if (i == 0) {
			return comp.width;
		}
		return i + "px";
	}

	/**
	 * added by k.taira
	 * 
	 * @return
	 */
	public static Integer getInternalWidthByInteger(BoxComponent comp) {
		if (comp.el() == null && comp.width != null) {
			return GxtUtil.safeParseInteger(comp.width.replace("px", ""));
		}
		int i = comp.getWidth();
		if (i == 0) {
			String s;
			if (comp.width != null) {
				s = comp.width.replace("px", "");
			} else {
				s = DOM.getStyleAttribute(comp.getElement(), "width");
			}
			return GxtUtil.safeParseInteger(s.replace("px", ""));
		}
		return i;
	}

	/**
	 * added by k.taira
	 * 
	 * @param width
	 */
	public static void setInternalWidth(BoxComponent comp, String width) {
		if (!width.replaceAll("px", "").trim().equals(0)) {
			comp.width = width;
		}
	}

	/**
	 * added by k.taira
	 * 
	 * @return
	 */
	public static String getInternalHeight(BoxComponent comp) {
		if (comp.el() == null) {
			return comp.height;
		}
		int i = comp.getHeight();
		if (i == 0) {
			return comp.height;
		}
		return i + "px";
	}

	/**
	 * added by k.taira
	 * 
	 * @return
	 */
	public static Integer getInternalHeightByInteger(BoxComponent comp) {
		if (comp.el() == null && comp.height != null) {
			return GxtUtil.safeParseInteger(comp.height.replace("px", ""));
		}
		int i = comp.getHeight();
		if (i == 0) {
			String s;
			if (comp.height != null) {
				s = comp.height.replace("px", "");
			} else {
				s = DOM.getStyleAttribute(comp.getElement(), "height");
			}
			return GxtUtil.safeParseInteger(s.replace("px", ""));
		}
		return i;
	}

	/**
	 * added by k.taira
	 * 
	 * @param width
	 */
	public static void setInternalHeight(BoxComponent comp, String height) {
		if (!height.replaceAll("px", "").trim().equals(0)) {
			comp.height = height;
		}
	}

	public static int getHeight(Grid grid) {
		if (grid.el() == null) {
			if (grid.height != null) {
				String s = grid.height.replace("px", "");
				return Integer.parseInt(s);
			} else {
				return 0;
			}
		}
		return grid.getHeight();
	}

	public static void setHeader(ContentPanel panel, Header header) {
		panel.head = header;
	}

	public static boolean isHasListeners(Component comp) {
		return comp.hasListeners;
	}

}
