/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.GridDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnConfigWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnModelWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.LayoutDataWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.LayoutWidget;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.ColumnData;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;

public class PropDialog extends Window {

	protected Component widget;

	protected Map<String, Field> fieldMap;

	protected int maxCol = 5;

	protected FormPanel panel;

	public PropDialog(Component widget) {
		super();
		setWidth(860);
		// setLayout(new FitLayout());
		ButtonBar bb = new ButtonBar();
		Button bt = new Button("set");
		bb.add(bt);
		getHeader().addTool(bb);
		bt.addSelectionListener(new SelectionListener<ComponentEvent>() {
			@Override
			public void componentSelected(ComponentEvent ce) {
				setProps();
			}
		});
		this.widget = widget;
		WidgetService ws = WidgetServiceFactory.getService(widget);
		if (ws == null) {
			return;
		}
		setHeading("properties - " + ws.getLabel() + ":" + widget.getId());
		setTitle("properties - " + ws.getLabel() + ":" + widget.getId());
		panel = makePanel();
		add(panel);
		fieldMap = ws.getPropMap();
		int i = 0;
		List<String> keys = new ArrayList<String>(fieldMap.keySet());
		Collections.sort(keys);
		Iterator<String> it = keys.iterator();
		while (it.hasNext()) {
			Field field = fieldMap.get(it.next());
			if (i == 4) {
				i = 0;
			}
			String s = field.getFieldLabel();
			// label 13文字に制限
			if (s.length() > 14) {
				field.setFieldLabel(s.substring(0, 13));
			}
			gxFLP[i].add(field);
			i++;
		}
	}

	protected void setProps() {
		DesignPanel dp = DesignPanel.getInstance();
		dp.checkPoint();
		WidgetService ws = WidgetServiceFactory.getService(widget);
		Component cl;
		if (ws.isSetAfterRender()) {
			ws.setPropMap(fieldMap);
			hide();
			return;
		} else {
			cl = ws.getClone();
		}
		WidgetService clws = WidgetServiceFactory.getService(cl);
		clws.setPropMap(fieldMap);
		GxtUtil.resetToParent2(widget, ws.getParent(), cl);
		this.widget = cl;
		if (cl instanceof LayoutDataWidget && cl.getParent() != null
				&& cl.getParent().getParent() instanceof LayoutContainer) {
			Component comp = (Component) cl.getParent();
			// LayoutDataWidget ld = (LayoutDataWidget) cl;
			LayoutContainer lc = (LayoutContainer) cl.getParent().getParent();
			Component clone = WidgetServiceFactory.getService(comp).getClone();
			// ComponentHelper.setLayoutData(clone, ld.getWrapLayoutData());
			GxtUtil.resetToParent2(comp, lc, clone);
		} else if (cl instanceof LayoutWidget
				&& clws.getParent() instanceof LayoutContainer) {
			LayoutContainer lc = (LayoutContainer) clws.getParent();
			Component lcclone = WidgetServiceFactory.getService(lc).getClone();
			// ComponentHelper.setLayoutData(clone, ld.getWrapLayoutData());
			GxtUtil.resetToParent2(lc, (Component) lc.getParent(), lcclone);
		} else if (cl instanceof ColumnConfigWidget) {
			Grid<ModelData> grid = (Grid<ModelData>) cl.getParent().getParent();
			ColumnModelWidget cmw = (ColumnModelWidget) cl.getParent();
			GridDelegate.remakeGrid(grid, cmw.getWrapModel());
		} else if (cl.getParent() instanceof ButtonBar
				&& cl.getParent().getParent() == null) {
			Component cp = GxtUtil.findParent((Component) cl.getParent());
			if (cp != null) {
				WidgetService wscp = WidgetServiceFactory.getService(cp);
				Component cpcl = wscp.getClone();
				GxtUtil.resetToParent2(cp, (Component) cp.getParent(), cpcl);
			}
		}
		DesignPanel.getInstance().panel.layout();
		hide();
	}

	private LayoutContainer[] gxFLP = new LayoutContainer[5];

	private FormPanel makePanel() {
		FormPanel gxFP_1;
		LayoutContainer gxCLP_1;
		ColumnData gxCLOD_1;
		FormLayout gxFMLO_1;
		ColumnData gxCLOD_2;
		FormLayout gxFMLO_2;
		ColumnData gxCLOD_3;
		FormLayout gxFMLO_3;
		ColumnData gxCLOD_4;
		FormLayout gxFMLO_4;
		ColumnLayout gxCLO_1;
		FlowLayout gxFLLO_1;
		gxFP_1 = new FormPanel();
		// gxFP_1.setWidth(700);
		gxFP_1.setHeaderVisible(false);
		gxCLP_1 = new LayoutContainer();
		gxFP_1.add(gxCLP_1);
		gxFLP[0] = new LayoutContainer();
		gxFLP[0].setTitle("gxFLP1");
		gxCLOD_1 = new ColumnData();
		gxCLOD_1.setWidth(0.25);
		gxCLP_1.add(gxFLP[0], gxCLOD_1);
		gxFMLO_1 = new FormLayout();
		gxFMLO_1.setDefaultWidth(80);
		gxFMLO_1.setLabelWidth(80);
		gxFLP[0].setLayout(gxFMLO_1);
		gxFLP[1] = new LayoutContainer();
		gxFLP[1].setTitle("gxFLP2");
		gxCLOD_2 = new ColumnData();
		gxCLOD_2.setWidth(0.25);
		gxCLP_1.add(gxFLP[1], gxCLOD_2);
		gxFMLO_2 = new FormLayout();
		gxFMLO_2.setDefaultWidth(80);
		gxFMLO_2.setLabelWidth(80);
		gxFLP[1].setLayout(gxFMLO_2);
		gxFLP[2] = new LayoutContainer();
		gxFLP[2].setTitle("gxFLP3");
		gxCLOD_3 = new ColumnData();
		gxCLOD_3.setWidth(0.25);
		gxCLP_1.add(gxFLP[2], gxCLOD_3);
		gxFMLO_3 = new FormLayout();
		gxFMLO_3.setDefaultWidth(80);
		gxFMLO_3.setLabelWidth(80);
		gxFLP[2].setLayout(gxFMLO_3);
		gxFLP[3] = new LayoutContainer();
		gxFLP[3].setTitle("gxFLP4");
		gxCLOD_4 = new ColumnData();
		gxCLOD_4.setWidth(0.25);
		gxCLP_1.add(gxFLP[3], gxCLOD_4);
		gxFMLO_4 = new FormLayout();
		gxFMLO_4.setDefaultWidth(80);
		gxFMLO_4.setLabelWidth(80);
		gxFLP[3].setLayout(gxFMLO_4);
		gxCLO_1 = new ColumnLayout();
		gxCLP_1.setLayout(gxCLO_1);
		gxFLLO_1 = new FlowLayout();
		gxFP_1.setLayout(gxFLLO_1);
		return gxFP_1;
	}

	public FormPanel getPanel() {
		return panel;
	}

}
