/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.menu.Menu;

public interface WidgetService {

	public List<String>[] makeSource(List<String>[] lists,
			Map<Object, Object> map);

	public Menu makeBar();

	public String getLabel();

	public String getTag();

	public String getFieldString();

	public String getInstanceString();

	public Component getInstance();

	public Component getInstance(String constracter, Map<String, Object> map);

	public Component setInitStyle(Component widget);

	public void setClickEvent(ComponentEvent event);

	public Component addWidget(Component widget);

	public void onAdd(Component parent);

	public Component removeWidget(Component widget);

	public Map<String, Field> getPropMap();

	public void setPropMap(Map<String, Field> fieldMap);

	public String getAddCode(Component widget, List<String>[] lists,
			String parentFiledName, String fieldName, Map<Object, Object> map);

	public Object execByString(String s, Map objMap);

	public Component getClone();

	public void setTargetInfo(Component parent, Component child);

	public boolean isAddable();

	public boolean isAddableToParent(Component parent);

	public boolean isRemovableToParent(Component parent);

	public List getProps();

	public List getInnerProps();

	public Object exec(String mthodName, Object[] parms);

	public Component shallowCopy(Component widget);

	public boolean isClickResize();

	public Component getParent();

	public boolean isSetAfterRender();

	public Iterator<Component> childrenIterator();

	public String getCategory();

	public void setLtext(String prop, Field ltext);
	
	public String getIconStyle();

}
