/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

public class WidgetServiceWrapper implements WidgetService {

	private WidgetService ws;

	// private Component widget;
	//
	// private Component parent;

	public WidgetServiceWrapper(WidgetService ws, Component widget) {
		super();
		this.ws = ws;
		// this.widget = widget;
		// this.parent = parent;
	}

	public Component addWidget(Component widget) {
		return ws.addWidget(widget);
	}

	public Object exec(String mthodName, Object[] parms) {
		return ws.exec(mthodName, parms);
	}

	public Object execByString(String s, Map objMap) {
		return ws.execByString(s, objMap);
	}

	public String getAddCode(Component widget, List<String>[] lists,
			String parentFiledName, String fieldName, Map<Object, Object> map) {
		return ws.getAddCode(widget, lists, parentFiledName, fieldName, map);
	}

	public Component getClone() {
		return ws.getClone();
	}

	public String getFieldString() {
		return ws.getFieldString();
	}

	public List getInnerProps() {
		return ws.getInnerProps();
	}

	public Component getInstance() {
		// すべてのcomponentのrenderを拾う
		return GxtUtil.addRender(ws.getInstance());
	}

	public Component getInstance(String constracter, Map<String, Object> map) {
		return GxtUtil.addRender(ws.getInstance(constracter, map));
	}

	public String getInstanceString() {
		return ws.getInstanceString();
	}

	public String getLabel() {
		return ws.getLabel();
	}

	public Component getParent() {
		return ws.getParent();
	}

	public Map<String, Field> getPropMap() {
		return ws.getPropMap();
	}

	public List getProps() {
		return ws.getProps();
	}

	public String getTag() {
		return ws.getTag();
	}

	public boolean isAddable() {
		return ws.isAddable();
	}

	public boolean isAddableToParent(Component parent) {
		return ws.isAddableToParent(parent);
	}

	public boolean isClickResize() {
		return ws.isClickResize();
	}

	public boolean isRemovableToParent(Component parent) {
		return ws.isRemovableToParent(parent);
	}

	public boolean isSetAfterRender() {
		return ws.isSetAfterRender();
	}

	public Menu makeBar() {
		return ws.makeBar();
	}

	public List<String>[] makeSource(List<String>[] lists,
			Map<Object, Object> map) {
		return ws.makeSource(lists, map);
	}

	public void onAdd(Component parent) {
		ws.onAdd(parent);
	}

	public Component removeWidget(Component widget) {
		return ws.removeWidget(widget);
	}

	public void setClickEvent(ComponentEvent event) {
		ws.setClickEvent(event);
	}

	public Component setInitStyle(Component widget) {
		// すべてのcomponentのrenderを拾う
		return GxtUtil.addRender(ws.setInitStyle(widget));
	}

	public void setPropMap(Map<String, Field> fieldMap) {
		ws.setPropMap(fieldMap);
	}

	public void setTargetInfo(Component parent, Component child) {
		ws.setTargetInfo(parent, child);
	}

	public Component shallowCopy(Component widget) {
		return ws.shallowCopy(widget);
	}

	public Iterator<Component> childrenIterator() {
		return ws.childrenIterator();
	}

	public String getCategory() {
		return ws.getCategory();
	}

	public void setLtext(String prop, Field ltext) {
		ws.setLtext(prop, ltext);
	}

	public WidgetService getWrapWidgetService() {
		return ws;
	}

	public String getIconStyle() {
		return ws.getIconStyle();
	}

}
