/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.util.Point;
import com.extjs.gxt.ui.client.util.Rectangle;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.WidgetHelper;

public class BoxComponentDelegate extends ComponentDelegate {

	private BoxComponent comp;

	// bouds pagePosition copy不可
	protected String[] props = { "autoHeight", "autoWidth", "deferHeight",
			"shadow", "shim" };

	protected String[] innerProps = { "deferHeight", "shim", "autoHeight",
			"shadow", "autoWidth", "internalHeight", "internalWidth" };

	public BoxComponentDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (BoxComponent) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {

		if (comp.el() != null) {
			if ("getHeight".equals(mthodName)) {
				return WidgetHelper.getInternalHeightByInteger(comp);
			} else if ("getWidth".equals(mthodName)) {
				return WidgetHelper.getInternalWidthByInteger(comp);
			}
		}
		if ("getInternalHeight".equals(mthodName)) {
			return WidgetHelper.getInternalHeight(comp);
		} else if ("getInternalWidth".equals(mthodName)) {
			return WidgetHelper.getInternalWidth(comp);
		} else if ("getWidth".equals(mthodName)) {
			return comp.getWidth();
		} else if ("setHeight".equals(mthodName) && parms[0] instanceof String) {
			comp.setHeight((String) parms[0]);
			return comp;
		} else if ("setHeight".equals(mthodName) && parms[0] instanceof Integer) {
			comp.setHeight((Integer) parms[0]);
			return comp;
		} else if ("setWidth".equals(mthodName) && parms[0] instanceof String) {
			comp.setWidth((String) parms[0]);
			return comp;
		} else if ("setWidth".equals(mthodName) && parms[0] instanceof Integer) {
			comp.setWidth((Integer) parms[0]);
			return comp;
		} else if ("setInternalWidth".equals(mthodName)
				&& parms[0] instanceof String) {
			WidgetHelper.setInternalWidth(comp, (String) parms[0]);
			return comp;
		} else if ("setInternalHeight".equals(mthodName)
				&& parms[0] instanceof String) {
			WidgetHelper.setInternalHeight(comp, (String) parms[0]);
			return comp;
		} else if ("getSize".equals(mthodName)) {
			return comp.getSize();
		} else if ("getShadow".equals(mthodName)) {
			return comp.getShadow();
		} else if ("getWidth".equals(mthodName)) {
			return comp.getWidth();
		} else if ("isAutoHeight".equals(mthodName)) {
			return comp.isAutoHeight();
		} else if ("isAutoWidth".equals(mthodName)) {
			return comp.isAutoWidth();
		} else if ("isDeferHeight".equals(mthodName)) {
			return comp.isDeferHeight();
		} else if ("isShim".equals(mthodName)) {
			return comp.isShim();
		} else if ("getBounds".equals(mthodName)) {
			return comp.getBounds(true);
		} else if ("getPagePosition".equals(mthodName)) {
			return comp.getPosition(false);
		} else if ("setAutoHeight".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAutoHeight((Boolean) parms[0]);
			return comp;
		} else if ("setAutoWidth".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAutoWidth((Boolean) parms[0]);
			return comp;
		} else if ("setBounds".equals(mthodName)
				&& parms[0] instanceof Rectangle) {
			comp.setBounds((Rectangle) parms[0]);
			return comp;
		} else if ("setBounds".equals(mthodName) && parms[0] instanceof String) {
			comp.setBounds(GxtUtil.makeRectangle((String) parms[0]));
			return comp;
		} else if ("setDeferHeight".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setDeferHeight((Boolean) parms[0]);
			return comp;
		} else if ("setPagePosition".equals(mthodName)
				&& parms[0] instanceof Point) {
			comp.setPagePosition((Point) parms[0]);
			return comp;
		} else if ("setPagePosition".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setPagePosition(GxtUtil.makePoint((String) parms[0]));
			return comp;
		} else if ("setShadow".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setShadow((Boolean) parms[0]);
			return comp;
		} else if ("setShim".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setShim((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public boolean isClickResize() {
		return true;
	}

}
