/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Style.SelectionMode;
import com.extjs.gxt.ui.client.core.Template;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.DataList;
import com.extjs.gxt.ui.client.widget.DataListItem;
import com.extjs.gxt.ui.client.widget.DataListSelectionModel;
import com.extjs.gxt.ui.client.widget.menu.Menu;

public class DataListDelegate extends ScrollContainerDelegate {

	private DataList comp;

	protected String[] props = { "contextMenu", "selectionModel",
			"selectionMode", "checkable", "selectedItem", "trackMouseOver",
			"selectedItems" };

	protected String[] innerProps = { "contextMenu", "selectionModel",
			"selectionMode", "checkable", "selectedItem", "trackMouseOver",
			"selectedItems" };

	public DataListDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (DataList) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getChecked".equals(mthodName)) {
			return comp.getChecked();
		} else if ("getContextMenu".equals(mthodName)) {
			return comp.getContextMenu();
		} else if ("getSelectedItems".equals(mthodName)) {
			return comp.getSelectedItems();
		} else if ("isCheckable".equals(mthodName)) {
			return comp.isCheckable();
		} else if ("isFlat".equals(mthodName)) {
			return comp.isFlat();
		} else if ("isTrackMouseOver".equals(mthodName)) {
			return comp.isTrackMouseOver();
		} else if ("setCheckable".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setCheckable((Boolean) parms[0]);
			return comp;
		} else if ("setContextMenu".equals(mthodName)
				&& parms[0] instanceof Menu) {
			comp.setContextMenu((Menu) parms[0]);
			return comp;
		} else if ("setFlatStyle".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setFlatStyle((Boolean) parms[0]);
			return comp;
		} else if ("setItemTemplate".equals(mthodName)
				&& parms[0] instanceof Template) {
			comp.setItemTemplate((Template) parms[0]);
			return comp;
		} else if ("setSelectedItems".equals(mthodName)
				&& parms[0] instanceof List) {
			comp.setSelectedItems((List) parms[0]);
			return comp;
		} else if ("setTrackMouseOver".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setTrackMouseOver((Boolean) parms[0]);
			return comp;
		} else if ("getSelectionModel".equals(mthodName)) {
			return comp.getSelectionModel();
		} else if ("setSelectionMode".equals(mthodName)
				&& parms[0] instanceof SelectionMode) {
			comp.setSelectionMode((SelectionMode) parms[0]);
			return comp;
		} else if ("setSelectionModel".equals(mthodName)
				&& parms[0] instanceof DataListSelectionModel) {
			comp.setSelectionModel((DataListSelectionModel) parms[0]);
			return comp;
		} else if ("getSelectedItem".equals(mthodName)) {
			return comp.getSelectedItem();
		} else if ("getSelectedItem".equals(mthodName)) {
			return comp.getSelectedItem();
		}/* else if ("setSelectedItem".equals(mthodName)
				&& parms[0] instanceof Component) {
			comp.setSelectedItem((Component) parms[0]);
			return comp;
		}*/ else if ("setSelectedItem".equals(mthodName)
				&& parms[0] instanceof DataListItem) {
			comp.setSelectedItem((DataListItem) parms[0]);
			return comp;
		} else if ("getSelectionMode".equals(mthodName)) {
			return comp.getSelectionMode();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof DataListItem) {
			DataListItem dli = (DataListItem) widget;
			comp.add(dli);
		}
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget instanceof DataListItem) {
			DataListItem dli = (DataListItem) widget;
			comp.remove(dli);
		}
		return comp;
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-DL";
	}


}
