/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.extjs.gxt.ui.client.widget.form.PropertyEditor;
import com.extjs.gxt.ui.client.widget.form.Field.FieldMessages;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.menu.AdapterMenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.AdapterToolItem;

public class FieldDelegate extends BoxComponentDelegate {

	private Field comp;

	// "rawValue" 不要 value,originalValueは不要
	protected String[] props = { "readOnly", "name", "autoValidate",
			"emptyText", "fieldLabel", "hideLabel", "labelSeparator",
			"labelStyle", "messageTarget", "tabIndex", "validateOnBlur",
			"validationDelay" };

	// "rawValue" 不要 valueは不要?
	protected String[] innerProps = { "messageTarget", "emptyText",
			"labelSeparator", "hideLabel", "autoValidate", "validationDelay",
			"validateOnBlur", "fieldLabel", "propertyEditor", "readOnly",
			"originalValue", "labelStyle", "name", "messages", "value" };

	public FieldDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (Field) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getName".equals(mthodName)) {
			return comp.getName();
		} else if ("getValue".equals(mthodName)) {
			return comp.getValue();
		} else if ("setReadOnly".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setReadOnly((Boolean) parms[0]);
			return comp;
		} else if ("setName".equals(mthodName) && parms[0] instanceof String) {
			comp.setName((String) parms[0]);
			return comp;
		} else if ("isReadOnly".equals(mthodName)) {
			return comp.isReadOnly();
		} else if ("setValue".equals(mthodName) && parms[0] instanceof Object) {
			comp.setValue((Object) parms[0]);
			return comp;
		} else if ("isValid".equals(mthodName)) {
			return comp.isValid();
		} else if ("getAutoValidate".equals(mthodName)) {
			return comp.getAutoValidate();
		} else if ("getEmptyText".equals(mthodName)) {
			return comp.getEmptyText();
		} else if ("getFieldLabel".equals(mthodName)) {
			return comp.getFieldLabel();
		} else if ("getLabelSeparator".equals(mthodName)) {
			return comp.getLabelSeparator();
		} else if ("getLabelStyle".equals(mthodName)) {
			return comp.getLabelStyle();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessageTarget".equals(mthodName)) {
			return comp.getMessageTarget();
		} else if ("getOriginalValue".equals(mthodName)) {
			return comp.getOriginalValue();
		} else if ("getPropertyEditor".equals(mthodName)) {
			return comp.getPropertyEditor();
		} else if ("getRawValue".equals(mthodName)) {
			return comp.getRawValue();
		} else if ("getValidateOnBlur".equals(mthodName)) {
			return comp.getValidateOnBlur();
		} else if ("getValidationDelay".equals(mthodName)) {
			return comp.getValidationDelay();
		} else if ("isDirty".equals(mthodName)) {
			return comp.isDirty();
		} else if ("isHideLabel".equals(mthodName)) {
			return comp.isHideLabel();
		} else if ("setAutoValidate".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAutoValidate((Boolean) parms[0]);
			return comp;
		} else if ("setEmptyText".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setEmptyText((String) parms[0]);
			return comp;
		} else if ("setFieldLabel".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setFieldLabel((String) parms[0]);
			return comp;
		} else if ("setHideLabel".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setHideLabel((Boolean) parms[0]);
			return comp;
		} else if ("setLabelSeparator".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setLabelSeparator((String) parms[0]);
			return comp;
		} else if ("setLabelStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setLabelStyle((String) parms[0]);
			return comp;
		} else if ("setMessages".equals(mthodName)
				&& parms[0] instanceof FieldMessages) {
			comp.setMessages((FieldMessages) parms[0]);
			return comp;
		} else if ("setMessageTarget".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setMessageTarget((String) parms[0]);
			return comp;
		} else if ("setOriginalValue".equals(mthodName)
				&& parms[0] instanceof Object) {
			comp.setOriginalValue((Object) parms[0]);
			return comp;
		} else if ("setPropertyEditor".equals(mthodName)
				&& parms[0] instanceof PropertyEditor) {
			comp.setPropertyEditor((PropertyEditor) parms[0]);
			return comp;
		} else if ("setRawValue".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setRawValue((String) parms[0]);
			return comp;
		} else if ("setTabIndex".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setTabIndex(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setValidateOnBlur".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setValidateOnBlur((Boolean) parms[0]);
			return comp;
		} else if ("setValidationDelay".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setValidationDelay(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		if (parent instanceof AdapterToolItem || parent instanceof AdapterField
				|| parent instanceof AdapterMenuItem) {
			return true;
		} else if (parent instanceof LayoutContainer) {
			LayoutContainer lc = (LayoutContainer) parent;
			return lc.getLayout() instanceof FormLayout;
		}
		return false;
	}

	@Override
	public boolean isRemovableToParent(Component parent) {
		if (parent instanceof MultiField) {
			MultiField mf = (MultiField) parent;
			if (mf.getAll().size() < 2) {
				return false;
			}
		}
		return true;
	}

	@Override
	public Component setInitStyle(Component widget) {
		Field f = (Field) widget;
		f.setFieldLabel(GxtUtil.getNewTag(service.getTag()));
		return f;
	}

	@Override
	public String getCategory() {
		return "Field";
	}

}
