/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;

import com.extjs.gxt.ui.client.Style.Orientation;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;

public class RowLayoutPanelDelegate extends RowLayoutContainerDelegate {

	public RowLayoutPanelDelegate(WidgetService service, Component widget) {
		super(service, widget);
	}

	@Override
	public Component setInitStyle(Component widget) {
		// RowLayout
		ContentPanel panel = new ContentPanel();
		panel.setHeading("RowLayout");
		panel.setLayout(new RowLayout(Orientation.VERTICAL));
		panel.setSize(400, 300);
		panel.setFrame(true);
		panel.setCollapsible(true);

		Text label1 = new Text("Test Label 1");
		label1.addStyleName("pad-text");
		// 現在のところsetStyleAttributeサポートできない
		// label1.setStyleAttribute("backgroundColor", "white");
		label1.setBorders(true);

		Text label2 = new Text("Test Label 2");
		label2.addStyleName("pad-text");
		// label2.setStyleAttribute("backgroundColor", "white");
		label2.setBorders(true);

		Text label3 = new Text("Test Label 3");
		label3.addStyleName("pad-text");
		// label3.setStyleAttribute("backgroundColor", "white");
		label3.setBorders(true);

		panel.add(label1, new RowData(1, -1, new Margins(4)));
		panel.add(label2, new RowData(1, 1, new Margins(0, 4, 0, 4)));
		panel.add(label3, new RowData(1, -1, new Margins(4)));

		return panel;
	}

	@Override
	public String getCategory() {
		return "Panel/Sample";
	}

}
