/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.Date;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.TimeField;
import com.google.gwt.i18n.client.DateTimeFormat;


public class TimeFieldDelegate extends ComboBoxDelegate {

	private TimeField comp;

	protected String[] props = { "increment", "minValue", "format", "maxValue" };

	protected String[] innerProps = { "increment", "minValue", "format",
			"maxValue" };

	public TimeFieldDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TimeField) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getDateValue".equals(mthodName)) {
			return comp.getDateValue();
		} else if ("getIncrement".equals(mthodName)) {
			return comp.getIncrement();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("getMessages".equals(mthodName)) {
			return comp.getMessages();
		} else if ("setIncrement".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setIncrement(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setMaxValue".equals(mthodName) && parms[0] instanceof Date) {
			comp.setMaxValue((Date) parms[0]);
			return comp;
		} else if ("setMinValue".equals(mthodName) && parms[0] instanceof Date) {
			comp.setMinValue((Date) parms[0]);
			return comp;
		} else if ("getFormat".equals(mthodName)) {
			return comp.getFormat();
		} else if ("setFormat".equals(mthodName)
				&& parms[0] instanceof DateTimeFormat) {
			comp.setFormat((DateTimeFormat) parms[0]);
			return comp;
		} else if ("getMaxValue".equals(mthodName)) {
			return comp.getMaxValue();
		} else if ("getMinValue".equals(mthodName)) {
			return comp.getMinValue();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-Time";
	}


}
