/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.toolbar.TextToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.extjs.gxt.ui.client.widget.toolbar.ToolItem;

public class ToolBarDelegate extends ContainerDelegate {

	private ToolBar comp;

	protected String[] props = { "buttonAlign" };

	protected String[] innerProps = { "buttonAlign" };

	public ToolBarDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (ToolBar) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@SuppressWarnings("deprecation")
	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getButtonAlign".equals(mthodName)) {
			return comp.getButtonAlign();
		} else if ("setButtonAlign".equals(mthodName)
				&& parms[0] instanceof HorizontalAlignment) {
			comp.setButtonAlign((HorizontalAlignment) parms[0]);
			return comp;
		} else if ("add".equals(mthodName) && parms[0] instanceof ToolItem) {
			comp.add((ToolItem) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof ToolItem) {
			ToolItem item = (ToolItem) widget;
			if (insertIdx != -1) {
				comp.insert(item, insertIdx);
				insertIdx = -1;
			} else {
				comp.add(item);
			}
		}
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget instanceof ToolItem) {
			comp.remove((ToolItem) widget);
		}
		return comp;
	}

	@Override
	public Component setInitStyle(Component widget) {
		ToolBar tb = (ToolBar) widget;
		tb.add(new TextToolItem(GxtUtil.getNewTag(service.getTag())));
		return tb;
	}

	@Override
	public String getCategory() {
		return "Tool/Menu";
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-TB";
	}



}
