/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.extjs.gxt.ui.client.widget.toolbar.ToolItem;

public class ToolItemDelegate extends ComponentDelegate {

	private ToolItem comp;

	protected String[] props = {};

	protected String[] innerProps = {};

	public ToolItemDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (ToolItem) widget;
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getToolBar".equals(mthodName)) {
			return comp.getToolBar();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		if (parent instanceof ToolBar) {
			return true;
		}
		return super.isAddableToParent(parent);
	}

	@Override
	public Component getParent() {
		if (comp.getToolBar() != null) {
			return comp.getToolBar();
		}
		return super.getParent();
	}
	
	@Override
	public String getCategory() {
		return "Tool/Menu";
	}


}
