/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Events;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.tree.Tree;
import com.extjs.gxt.ui.client.widget.tree.TreeHelper;
import com.extjs.gxt.ui.client.widget.tree.TreeItem;
import com.extjs.gxt.ui.client.widget.tree.TreeItemUI;

public class TreeItemDelegate extends ComponentDelegate {

	private TreeItem comp;

	// ui不要
	protected String[] props = { "iconStyle", "text", "textStyle", "leaf",
			"expanded", "checked", "itemStyleName" };

	protected String[] innerProps = { "iconStyle", "text", "textStyle", "leaf",
			"expanded", "checked", "itemStyleName" };

	public TreeItemDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TreeItem) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getIconStyle".equals(mthodName)) {
			return comp.getIconStyle();
		} else if ("getItems".equals(mthodName)) {
			return comp.getItems();
		} else if ("getItemStyleName".equals(mthodName)) {
			return comp.getItemStyleName();
		} else if ("getParentItem".equals(mthodName)) {
			return comp.getParentItem();
		} else if ("getTextStyle".equals(mthodName)) {
			return comp.getTextStyle();
		} else if ("isChecked".equals(mthodName)) {
			return comp.isChecked();
		} else if ("getTree".equals(mthodName)) {
			return TreeHelper.getTree(comp);
		} else if ("setChecked".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setChecked((Boolean) parms[0]);
			return comp;
		} else if ("setExpanded".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setExpanded((Boolean) parms[0]);
			return comp;
		} else if ("setIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setIconStyle((String) parms[0]);
			return comp;
		} else if ("setItemStyleName".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setItemStyleName((String) parms[0]);
			return comp;
		} else if ("setLeaf".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setLeaf((Boolean) parms[0]);
			return comp;
		} else if ("setTextStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTextStyle((String) parms[0]);
			return comp;
		} else if ("setTree".equals(mthodName) && parms[0] instanceof Tree) {
			TreeHelper.setTree(comp, (Tree) parms[0]);
			return comp;
		} else if ("getPath".equals(mthodName)) {
			return comp.getPath();
		} else if ("getText".equals(mthodName)) {
			return comp.getText();
		} else if ("setText".equals(mthodName) && parms[0] instanceof String) {
			comp.setText((String) parms[0]);
			return comp;
		} else if ("getItemCount".equals(mthodName)) {
			return comp.getItemCount();
		} else if ("getUI".equals(mthodName)) {
			return comp.getUI();
		} else if ("setUI".equals(mthodName) && parms[0] instanceof TreeItemUI) {
			comp.setUI((TreeItemUI) parms[0]);
			return comp;
		} else if ("isLeaf".equals(mthodName)) {
			return comp.isLeaf();
		} else if ("getContainer".equals(mthodName)) {
			return comp.getContainer();
		} else if ("isRoot".equals(mthodName)) {
			return comp.isRoot();
		} else if ("isExpanded".equals(mthodName)) {
			return comp.isExpanded();
		} else if ("getDepth".equals(mthodName)) {
			return comp.getDepth();
		} else if ("add".equals(mthodName) && parms.length == 1
				&& parms[0] instanceof Component) {
			return service.addWidget((Component) parms[0]);
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public Component setInitStyle(Component widget) {
		TreeItem ti = (TreeItem) widget;
		WidgetService ws = WidgetServiceFactory.getService(widget);
		ti.setText(GxtUtil.getNewTag(ws.getTag()));
		//ti.setIconStyle("user");
		return ti;
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof TreeItem) {
			TreeItem tri = (TreeItem) widget;
			comp.add(tri);
		}
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget instanceof TreeItem) {
			TreeItem tri = (TreeItem) widget;
			comp.remove(tri);
			if (tri.isRendered()) {
				tri.fireEvent(Events.Orphan);
			}
		}
		return comp;
	}

	@Override
	public boolean isAddable() {
		if (this.widget instanceof TreeItem) {
			return true;
		}
		return false;
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		if (parent instanceof Tree || parent instanceof TreeItem) {
			return true;
		}
		return false;
	}

	@Override
	public List<Component> getChildren() {
		List<Component> l = super.getChildren();
		l.addAll(comp.getItems());
		return l;
	}

	@Override
	public Component getParent() {
		if (comp.isRoot()) {
			return TreeHelper.getTree(comp);
		}
		return comp.getParentItem();
	}

}
