/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.VerticalPanel;

public class VerticalPanelDelegate extends LayoutContainerDelegate {

	private VerticalPanel comp;

	protected String[] props = { "tableHeight", "spacing", "horizontalAlign",
			"verticalAlign", "tableWidth" };

	protected String[] innerProps = { "tableHeight", "spacing",
			"horizontalAlign", "verticalAlign", "tableWidth" };

	public VerticalPanelDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (VerticalPanel) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getHorizontalAlign".equals(mthodName)) {
			return comp.getHorizontalAlign();
		} else if ("getSpacing".equals(mthodName)) {
			return comp.getSpacing();
		} else if ("getTableHeight".equals(mthodName)) {
			return comp.getTableHeight();
		} else if ("getTableWidth".equals(mthodName)) {
			return comp.getTableWidth();
		} else if ("getVerticalAlign".equals(mthodName)) {
			return comp.getVerticalAlign();
		} else if ("setHorizontalAlign".equals(mthodName)
				&& parms[0] instanceof HorizontalAlignment) {
			comp.setHorizontalAlign((HorizontalAlignment) parms[0]);
			return comp;
		} else if ("setSpacing".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setSpacing(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setTableHeight".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTableHeight((String) parms[0]);
			return comp;
		} else if ("setTableWidth".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTableWidth((String) parms[0]);
			return comp;
		} else if ("setVerticalAlign".equals(mthodName)
				&& parms[0] instanceof VerticalAlignment) {
			comp.setVerticalAlign((VerticalAlignment) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public Component setInitStyle(Component widget) {
		VerticalPanel vp = (VerticalPanel) widget;
		vp.setBorders(true);
		vp.setSize(700, 400);
		return vp;
	}

	@Override
	public String getCategory() {
		return "Panel/Sample";
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-VP";
	}

}
