/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnLayoutWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.ColumnData;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;

public class ColumnLayoutDelegate extends LayoutDelegate {

	private ColumnLayoutWidget comp;

	protected String[] props = { "adjustForScroll" };

	public ColumnLayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (ColumnLayoutWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("isAdjustForScroll".equals(mthodName)) {
			return comp.isAdjustForScroll();
		} else if ("setAdjustForScroll".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAdjustForScroll((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public void resetLayoutWhenAdd(Component addComp) {
		if (!(ComponentHelper.getLayoutData(addComp) instanceof ColumnData)) {
			setColumnWidth(comp.getContainer());
		}
	}

	public static void setColumnWidth(LayoutContainer container) {
		if (!(container.getLayout() instanceof ColumnLayout)) {
			return;
		}
		List l = container.getItems();
		if (l.size() > 0) {
			int wt = 100 / l.size();
			double d = ((double) wt) / 103;
			for (int i = 0; i < l.size(); i++) {
				Component c = (Component) l.get(i);
				ColumnData cd = new ColumnData(d);
				ComponentHelper.setLayoutData(c, cd);
			}
		}

	}

}
