/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.GridDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnConfigWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnModelWidget;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;

public class ColumnModelDelegate extends ConfigDelegate {

	private ColumnModelWidget comp;

	protected String[] props = {};

	// protected String[] innerProps = { "parent" };

	protected String[] innerProps = {};

	public ColumnModelDelegate(WidgetService service, Component widget
) {
		super(service, widget);
		this.comp = (ColumnModelWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getParent".equals(mthodName)) {
			return comp.getParent();
		} else if ("setParent".equals(mthodName) && parms[0] instanceof Grid) {
			comp.setParent((Grid) parms[0]);
			return comp;
		} else if ("getColumnCount".equals(mthodName)) {
			return comp.getColumnCount();
		} else if ("getFiresEvents".equals(mthodName)) {
			return comp.getFiresEvents();
		} else if ("getTotalWidth".equals(mthodName)) {
			return comp.getTotalWidth();
		} else if ("getWrapModel".equals(mthodName)) {
			return comp.getWrapModel();
		} else if ("getConfigs".equals(mthodName)) {
			return comp.getConfig();
		} else if ("setConfigs".equals(mthodName) && parms[0] instanceof List) {
			comp.setConfig((List<ColumnConfig>) parms[0]);
			return comp;
		}
		return null;
	}

	@Override
	public String[] getProps() {
		return props;
	}

	@Override
	public String[] getInnerProps() {
		return innerProps;
	}

	@Override
	public List<Component> getChildren() {
		return comp.getColumnConfigWidgets();
	}


	protected int insertIdx = -1;

	public void setTargetInfo(Component parent, Component child) {
		insertIdx = -1;
		if (parent instanceof ColumnModelWidget
				&& child instanceof ColumnConfigWidget) {
			ColumnModel cm = ((ColumnModelWidget) parent).getWrapModel();
			ColumnConfig cc = ((ColumnConfigWidget) child).getWrapConfig();
			insertIdx = cm.getIndexById(cc.getId());
		}
	}

	@Override
	public void addWidget(Component widget) {
		ColumnConfigWidget ccf = (ColumnConfigWidget) widget;
		if (insertIdx == -1) {
			insertIdx = comp.getColumnCount();
		}
		comp.add(ccf, insertIdx);
		insertIdx = -1;
		Grid grid = GridDelegate.resetColumnModel((Grid<ModelData>) comp.getParent(), comp
				.getWrapModel());
		comp.setGrid(grid);
	}

	@Override
	public Component removeWidget(Component widget) {
		ColumnConfigWidget ccf = (ColumnConfigWidget) widget;
		comp.remove(ccf);
		Grid grid = GridDelegate.resetColumnModel((Grid<ModelData>) comp.getParent(), comp
				.getWrapModel());
		comp.setGrid(grid);
		return comp;
	}

	@Override
	public String getAddCode(Component widget, List[] lists,
			String parentFiledName, String fieldName, Map map) {
		return parentFiledName + "_l.add(" + fieldName + ");";
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		return false;
	}

	@Override
	public boolean isAddable() {
		return true;
	}

}
