/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.TableRowLayoutWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.LayoutContainerHelper;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;

public class TableRowLayoutDelegate extends TableLayoutDelegate {

	protected String[] props = {};

	private TableRowLayoutWidget comp;

	public TableRowLayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TableRowLayoutWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public void resetLayoutWhenAdd(Component addComp) {
		if (!(ComponentHelper.getLayoutData(addComp) instanceof TableData)) {
			setTableWidthHight(comp.getContainer());
		}
	}

	public static void setTableWidthHight(LayoutContainer container) {
		if (!(container.getLayout() instanceof TableLayout)) {
			return;
		}
		container.layout();
		List l = container.getItems();
		if (l.size() > 0) {
			String w = LayoutContainerHelper.getWidth(container);
			for (int i = 0; i < l.size(); i++) {
				Component c = (Component) l.get(i);
				TableData td = new TableData();
				td.setWidth(w);
				ComponentHelper.setLayoutData(c, td);
			}
		}

	}

}
