/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.model;

import java.util.Date;

import jp.co.kpscorp.gwt.client.design.gxt.common.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.common.LabelModel;

import com.extjs.gxt.ui.client.data.BeanModelTag;
import com.google.gwt.user.client.rpc.IsSerializable;

public class Machine implements IsSerializable, BeanModelTag, LabelModel {

	private static final String[][] labels = { { "serialNo", "シリアルNo" },
			{ "ipAddress", "IPアドレス" }, { "macAddress", "MACアドレス" },
			{ "machineName", "機器名称" }, { "sapNo", "SAP管理No." },
			{ "capitalizationDate", "資産化日付" }, { "updTime", "UpdateTime" },
			{ "machinePk", "機器情報PK" }, { "state", "状態" },
			{ "hostName", "ホスト名" } };

	public String label(String prop) {
		return GxtUtil.prop2Label(prop, labels);
	}

	/** identifier field */
	private Integer machinePk;

	/** persistent field */
	private String serialNo;

	/** nullable persistent field */
	private String ipAddress;

	/** nullable persistent field */
	private String macAddress;

	/** nullable persistent field */
	private String hostName;

	/** nullable persistent field */
	private String machineName;

	/** persistent field */
	private Integer state = 0;

	/** nullable persistent field */
	private String sapNo;

	/** nullable persistent field */
	private Date capitalizationDate;

	/** nullable persistent field */
	private Date updTime;

	/** persistent field */
	private Lease lease;

	/** persistent field */
	private Maintenance maintenance;

	/** persistent field */
	private Rack rack;

	public Machine() {
	}

	public Machine(Machine machine) {
		super();
		this.machinePk = null;
		this.serialNo = machine.getSerialNo();
		this.ipAddress = machine.getIpAddress();
		this.macAddress = machine.getMacAddress();
		this.hostName = machine.getHostName();
		this.machineName = machine.getMachineName();
		if (machine.getState() == null) {
			this.state = 0;
		} else {
			this.state = machine.getState();
		}
		this.sapNo = machine.getSapNo();
		this.capitalizationDate = machine.getCapitalizationDate();
		this.updTime = machine.getUpdTime();
		this.lease = machine.getLease();
		this.maintenance = machine.getMaintenance();
		this.rack = machine.getRack();
	}

	public Integer getMachinePk() {
		return machinePk;
	}

	public void setMachinePk(Integer machinePk) {
		this.machinePk = machinePk;
	}

	public String getSerialNo() {
		return serialNo;
	}

	public void setSerialNo(String serialNo) {
		this.serialNo = serialNo;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	public String getMacAddress() {
		return macAddress;
	}

	public void setMacAddress(String macAddress) {
		this.macAddress = macAddress;
	}

	public String getHostName() {
		return hostName;
	}

	public void setHostName(String hostName) {
		this.hostName = hostName;
	}

	public String getMachineName() {
		return machineName;
	}

	public void setMachineName(String machineName) {
		this.machineName = machineName;
	}

	public String getSapNo() {
		return sapNo;
	}

	public void setSapNo(String sapNo) {
		this.sapNo = sapNo;
	}

	public Date getCapitalizationDate() {
		return capitalizationDate;
	}

	public void setCapitalizationDate(Date capitalizationDate) {
		this.capitalizationDate = capitalizationDate;
	}

	public Date getUpdTime() {
		return updTime;
	}

	public void setUpdTime(Date updTime) {
		this.updTime = updTime;
	}

	public Lease getLease() {
		return lease;
	}

	public void setLease(Lease lease) {
		this.lease = lease;
	}

	public Maintenance getMaintenance() {
		return maintenance;
	}

	public void setMaintenance(Maintenance maintenance) {
		this.maintenance = maintenance;
	}

	public Rack getRack() {
		return rack;
	}

	public void setRack(Rack rack) {
		this.rack = rack;
	}

	public String getLabel() {
		return null;
	}

	public String getValue() {
		return null;
	}

	public int compareTo(Object o) {
		return 0;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

}
