/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.model;

import java.util.Date;
import java.util.Set;

import jp.co.kpscorp.gwt.client.design.gxt.common.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.common.LabelModel;

import com.extjs.gxt.ui.client.data.BeanModelTag;
import com.google.gwt.user.client.rpc.IsSerializable;

public class Place implements IsSerializable, BeanModelTag, LabelModel {

	private static final String[][] labels = { { "updTime", "UpdateTime" },
			{ "placePk", "拠点PK" }, { "placeName", "拠点名" },
			{ "placeAddress", "住所" } };

	public String label(String prop) {
		return GxtUtil.prop2Label(prop, labels);
	}

	/** identifier field */
	private Integer placePk;

	/** persistent field */
	private String placeName;

	/** nullable persistent field */
	private String placeAddress;

	/** nullable persistent field */
	private Date updTime;

	/** persistent field */
	private Set floors;

	public Place() {
	}

	public Place(Place place) {
		super();
		this.placePk = null;
		this.placeName = place.getPlaceName();
		this.placeAddress = place.getPlaceAddress();
		this.updTime = place.getUpdTime();
		this.floors = place.getFloors();
	}

	public Integer getPlacePk() {
		return placePk;
	}

	public void setPlacePk(Integer placePk) {
		this.placePk = placePk;
	}

	public String getPlaceName() {
		return placeName;
	}

	public void setPlaceName(String placeName) {
		this.placeName = placeName;
	}

	public String getPlaceAddress() {
		return placeAddress;
	}

	public void setPlaceAddress(String placeAddress) {
		this.placeAddress = placeAddress;
	}

	public Date getUpdTime() {
		return updTime;
	}

	public void setUpdTime(Date updTime) {
		this.updTime = updTime;
	}

	public Set getFloors() {
		return floors;
	}

	public void setFloors(Set floors) {
		this.floors = floors;
	}

	public String getLabel() {
		return null;
	}

	public String getValue() {
		return null;
	}

	public int compareTo(Object o) {
		return 0;
	}

}
