/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.layout;

import java.util.Arrays;

import jp.co.kpscorp.gwt.client.design.gxt.delegate.layout.BorderLayoutDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.widget.BorderLayoutWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;


public class WsBorderLayout extends WsLayout {

	private String fieldString = "BorderLayout ";

	private String instanceString = " = new BorderLayout();";

	private String tag = "gxBLO";

	public WsBorderLayout(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new BorderLayoutDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public Component getInstance() {
		return new BorderLayoutWidget(new BorderLayout(), null);
	}

	public String getLabel() {
		return "BorderLayout";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}


}
