/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.layout;

import java.util.Arrays;

import jp.co.kpscorp.gwt.client.design.gxt.delegate.layout.FitLayoutDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FitLayoutWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;


public class WsFitLayout extends WsLayout {

	private String fieldString = "FitLayout ";

	private String instanceString = " = new FitLayout();";

	private String tag = "gxFTLO";

	public WsFitLayout(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new FitLayoutDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public Component getInstance() {
		return new FitLayoutWidget(new FitLayout(), null);
	}

	public String getLabel() {
		return "FitLayout";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}


}
