/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.widget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;


public class LayoutWidget extends WrapWidget {

	private Layout layout;

	protected LayoutContainer container;

	public LayoutWidget(Layout layout, LayoutContainer container) {
		super();
		this.layout = layout;
		this.container = container;
	}

	public String getExtraStyle() {
		return layout.getExtraStyle();
	}

	public boolean getFiresEvents() {
		return layout.getFiresEvents();
	}

	public int getResizeDelay() {
		return layout.getResizeDelay();
	}

	public boolean isRenderHidden() {
		return layout.isRenderHidden();
	}

	public void setExtraStyle(String extraStyle) {
		layout.setExtraStyle(extraStyle);
	}

	public void setFiresEvents(boolean firesEvents) {
		layout.setFiresEvents(firesEvents);
	}

	public void setRenderHidden(boolean renderHidden) {
		layout.setRenderHidden(renderHidden);
	}

	public void setResizeDelay(int resizeDelay) {
		layout.setResizeDelay(resizeDelay);
	}

	public LayoutContainer getContainer() {
		return container;
	}

	public Layout getLayout() {
		return layout;
	}

	@Override
	public String getTitle() {
		String s = layout.getClass().getName();
		return s.substring(s.lastIndexOf('.') + 1);
	}

	@Override
	public Component getParent() {
		return this.container;
	}

	public void setContainer(LayoutContainer container) {
		this.container = container;
	}

}
