/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import com.google.gwt.user.client.ui.FlexTable;

public class CellFormaterPanel extends FormatterPanel {

	private final int cnt = 2;

	public CellFormaterPanel(FlexTable table) {
		super(table);
	}

	protected String[] getProps() {
		return delegate.getProps(cnt);
	}

	protected int getCount() {
		return delegate.getCount(cnt);
	}

	protected String getRowTitle() {
		return "row";
	}

	protected String getRowLabel(int i) {
		int[] addr = delegate.makeAddrByCnt(i);
		return "R" + addr[0] + "C" + addr[1];
	}

	protected String getPanelTitle() {
		return delegate.getClassName(cnt);
	}

}
