package jp.co.kpscorp.gwt.client.design;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class DefaultFactoryImp implements Factory {
	public WidgetService getService(Widget widget) {
		if (widget instanceof VerticalPanel) {
			return new WidgetServiceVP(widget);
		} else if (widget instanceof HorizontalPanel) {
			return new WidgetServiceHP(widget);
		} else if (widget instanceof SimplePanel) {
			return new WidgetServiceSP(widget);
		} else if (widget instanceof DockPanel) {
			return new WidgetServiceDP(widget);
		} else if (widget instanceof HTML) {
			return new WidgetServiceHT(widget);
		} else if (widget instanceof Label) {
			return new WidgetServiceLB(widget);
		} else if (widget instanceof TextBox) {
			return new WidgetServiceTB(widget);
		} else if (widget instanceof TextArea) {
			return new WidgetServiceTA(widget);
		} else if (widget instanceof Button) {
			return new WidgetServiceBT(widget);
		} else if (widget instanceof ListBox) {
			return new WidgetServiceLTB(widget);
		} else if (widget instanceof FlexTable) {
			return new WidgetServiceFT(widget);
		} else if (widget instanceof RadioButton) {
			return new WidgetServiceRB(widget);
		} else if (widget instanceof CheckBox) {
			return new WidgetServiceCB(widget);
		} else if (widget instanceof Image) {
			return new WidgetServiceIM(widget);
		}
		return null;
	}

	public List makeServiceList(Widget widget, Widget parent) {
		List l = new ArrayList();
		l.add(new WidgetServiceHP(widget, parent));
		l.add(new WidgetServiceVP(widget, parent));
		l.add(new WidgetServiceSP(widget, parent));
		l.add(new WidgetServiceDP(widget, parent));
		l.add(new WidgetServiceLB(widget, parent));
		l.add(new WidgetServiceHT(widget, parent));
		l.add(new WidgetServiceTB(widget, parent));
		l.add(new WidgetServiceTA(widget, parent));
		l.add(new WidgetServiceBT(widget, parent));
		l.add(new WidgetServiceLTB(widget, parent));
		l.add(new WidgetServiceFT(widget, parent));
		l.add(new WidgetServiceRB(widget, parent));
		l.add(new WidgetServiceCB(widget, parent));
		l.add(new WidgetServiceIM(widget, parent));
		return l;
	}

}
