/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import jp.co.kpscorp.gwt.client.resize.ResizableWindowEx;
import jp.co.kpscorp.gwt.client.resize.RootWindowEx;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.FormSubmitCompleteEvent;
import com.google.gwt.user.client.ui.FormSubmitEvent;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class DesignPanel extends DockPanel implements ClickListener {

	protected PopupPanel pop = new PopupPanel();

	protected Widget widget;

	protected Map elements = new HashMap();

	protected Map filedMap = new HashMap();

	protected SimplePanel panel;

	protected static DesignPanel designPanel = new DesignPanel();

	protected WidgetService service;

	protected Button srcBtn;

	protected Button rldBtn;

	protected Button impBtn;

	protected Button cssBtn;

	protected Button opnBtn;

	protected Button savBtn;

	protected Button clrBtn;

	protected TextBox cssBox;

	protected Element cssElm;

	protected Widget copy;

	protected Stack udStack = new Stack();

	protected Stack rdStack = new Stack();

	public static final String BaseTitle = "Design";

	protected int maxundo = 5;

	protected Command onFlightCmd;

	protected boolean isInCheckPoint = false;

	protected Map widetCnts = new HashMap();

	protected List styleNames = new ArrayList();

	protected RootWindowEx resizeMode = null;

	protected Widget edit = null;

	protected TextArea editTa;

	protected int[] editAddr;

	protected Element div;

	protected String styleRules;

	protected String wmsg = "Edited contents will be deleted,OK?";

	protected Map propMap = new HashMap();

	protected Label msgLabel = new Label("Right click here!");

	protected Map cPMap1 = new HashMap();

	protected Map cPMap2 = new HashMap();

	protected boolean isCloneSame = true;

	protected String saveHeight = "";

	protected String saveWidth = "";

	public static DesignPanel getInstance() {
		return designPanel;
	}

	protected DesignPanel() {
		super();
		init();
	}

	private void init() {
		panel = makePanel();
		panel.add(msgLabel);
		srcBtn.addClickListener(this);
		// rldBtn.addClickListener(this);
		impBtn.addClickListener(this);
		cssBtn.addClickListener(this);
		opnBtn.addClickListener(this);
		savBtn.addClickListener(this);
		clrBtn.addClickListener(this);
		addListener(panel);
		// cssBox.setText("c:\\test.css");
		accessSessionCss("getAttribute");
		makeStylenames();
		styleRules = "";
		disableContextMenu();
	}

	private void makeStylenames() {
		try {
			List l = Util.devideStr(Util.getSelectorTexts(), ',');
			styleNames.clear();
			Iterator it = l.iterator();
			while (it.hasNext()) {
				String s = (String) it.next();
				if (s.indexOf(".") != -1) {
					styleNames.add(s.substring(s.indexOf(".") + 1).replaceAll(
							" .*", "").replaceAll(":.*", ""));
				}
			}
		} catch (RuntimeException e) {
		}
	}

	private SimplePanel makePanel() {
		SimplePanel sp_1;
		HorizontalPanel hp_1;
		setSpacing(10);
		// setHorizontalAlignment(DockPanel.ALIGN_CENTER);
		// setVerticalAlignment(DockPanel.ALIGN_MIDDLE);
		sp_1 = new SimplePanel();
		sp_1.setTitle(BaseTitle);
		sp_1.setStyleName("design-base");
		sp_1.setWidth("1200px");
		sp_1.setHeight("800px");
		add(sp_1, DockPanel.CENTER);
		hp_1 = new HorizontalPanel();
		Util.setSpacing(hp_1, 10);
		hp_1.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
		hp_1.setVerticalAlignment(VerticalPanel.ALIGN_TOP);
		add(hp_1, DockPanel.NORTH);
		srcBtn = new Button();
		srcBtn.setStyleName("design-Button");
		srcBtn.setWidth("80px");
		srcBtn.setText("generate");
		hp_1.add(srcBtn);
		impBtn = new Button();
		impBtn.setStyleName("design-Button");
		impBtn.setWidth("80px");
		impBtn.setText("import");
		hp_1.add(impBtn);
		// css reload機能凍結
		// rldBtn = new Button();
		// rldBtn.setStyleName("design-Button");
		// rldBtn.setWidth("100px");
		// rldBtn.setText("reload css");
		// hp_1.add(rldBtn);
		// cssBox = new TextBox();
		// cssBox.setStyleName("gwt-TextBox");
		// cssBox.setWidth("300px");
		// hp_1.add(cssBox);
		//
		cssBtn = new Button();
		cssBtn.setStyleName("design-Button");
		cssBtn.setWidth("100px");
		cssBtn.setText("add style");
		hp_1.add(cssBtn);
		opnBtn = new Button();
		opnBtn.setStyleName("design-Button");
		opnBtn.setWidth("100px");
		opnBtn.setText("open file");
		hp_1.add(opnBtn);
		savBtn = new Button();
		savBtn.setStyleName("design-Button");
		savBtn.setWidth("100px");
		savBtn.setText("save design");
		hp_1.add(savBtn);
		clrBtn = new Button();
		clrBtn.setStyleName("design-Button");
		clrBtn.setWidth("100px");
		clrBtn.setText("clear");
		hp_1.add(clrBtn);

		hp_1.setStyleName("design-BGBot");
		return sp_1;
	}

	public void importWidget(Widget widget) {
		Widget pw = panel.getWidget();
		if (pw != null) {
			panel.remove(pw);
		}
		WidgetService ws = WidgetServiceFactory.getService(panel);
		ws.addWidget(widget);
		importRec(widget);
	}

	public void importRec(Widget widget) {
		if (WidgetServiceFactory.getService(widget) != null) {
			addListener(widget);
		}
		if (widget instanceof HasWidgets) {
			HasWidgets hw = (HasWidgets) widget;
			Iterator it = hw.iterator();
			while (it.hasNext()) {
				Widget w = (Widget) it.next();
				importRec(w);
			}
		} else if (widget instanceof ResizableWindowEx) {
			ResizableWindowEx rex = (ResizableWindowEx) widget;
			importRec(rex.getWidget());
		}
	}

	public void addListener(Widget widget) {
		DOM.sinkEvents(widget.getElement(), Event.ONCLICK | Event.MOUSEEVENTS);
		DOM.setEventListener(widget.getElement(), this);
		elements.put(widget.getElement(), widget);
	}

	protected void doAttachChildren() {
		super.doAttachChildren();
		DOM.setEventListener(panel.getElement(), this);
	}

	public void onBrowserEvent(Event event) {
		DOM.eventCancelBubble(event, true);
		super.onBrowserEvent(event);
		if (DOM.eventGetType(event) == Event.ONCLICK
				|| DOM.eventGetButton(event) == Event.BUTTON_RIGHT) {

			if (panel.getWidget() == null) {
				panel.add(msgLabel);
			}
			Widget clickWidget = widgetFromEvent(event);
			// CtlLabelの場合は親を対象とする
			if (Util.isCtlLabel(clickWidget)) {
				this.widget = clickWidget.getParent();
			} else {
				this.widget = clickWidget;
			}
			service = WidgetServiceFactory.getService(this.widget);
			service.setClickEvent(event);
			if (DOM.eventGetType(event) == Event.ONCLICK) {
				if (edit != null) {
					if (editTa != this.widget) {
						new EditOff().execute();
					}
					return;
				}
				if (resizeMode != null) {
					if (resizeMode.getBaseWidget() == this.widget
							&& isEditable(this.widget)) {
						new ResizeModeOff().execute();
						new Edit().execute();
						return;
					}
					new ResizeModeOff().execute();
					return;
				}
				if (!BaseTitle.equals(this.widget.getTitle())
						&& service.isClickResize()) {
					new ResizeMode().execute();
					return;
				}
			}

			if (DOM.eventGetButton(event) == Event.BUTTON_RIGHT) {
				panel.remove(msgLabel);
				clickEvent(event);
			}
		}
	}

	protected Widget widgetFromEvent(Event event) {
		Element e = DOM.eventGetCurrentTarget(event);
		Widget clickWidget = (Widget) elements.get(e);
		return clickWidget;
	}

	private void clickEvent(Event event) {
		if (pop != null) {
			pop.hide();
		}
		pop = service.makeBar();
		pop.setPopupPosition(DOM.eventGetClientX(event), DOM
				.eventGetClientY(event));
		pop.show();
	}

	public MenuBar getAddBar() {
		MenuBar bar = new MenuBar(true);
		Iterator it = WidgetServiceFactory.makeServiceList(null, widget)
				.iterator();
		while (it.hasNext()) {
			WidgetService service = (WidgetService) it.next();
			if (service.isAddableToParent()) {
				bar.addItem(service.getLabel(), new Add(service));
			}
		}
		return bar;
	}

	public MenuBar addStandardBar(MenuBar bar, Widget widget) {
		boolean isBase = widget == panel;
		if (resizeMode == null && edit == null) {
			if (!isBase) {
				WidgetService ws = WidgetServiceFactory.getService(widget);
				if (ws.isRemovableToParent()) {
					bar.addItem("remove", new Remove());
				}
				bar.addItem("copy", new Copy());
				bar.addItem("cut", new Cut());
				if (WidgetServiceFactory.getService(widget).isClickResize()) {
					bar.addItem("resizeMode", new ResizeMode());
				}
				if (isEditable(widget)) {
					bar.addItem("edit", new Edit());
				}
			}
			if (getCopy() != null && Util.isAddable(widget)) {
				bar.addItem("paste", new Paste());
			}
			if (!isBase && !Util.isCtlLabel(widget)) {
				bar.addItem("properties", new Props());
				if (widget instanceof HasWidgets) {
					bar.addItem("all properties", new AllProps());
				}
			}
			if (isBase && panel.getWidget() != null
					&& panel.getWidget() instanceof HasWidgets) {
				bar.addItem("all properties", new AllProps());
			}
			bar.addItem("html", new ShowElement());
			if (!udStack.isEmpty()) {
				bar.addItem("undo", new Undo());
			}
			if (!rdStack.isEmpty()) {
				bar.addItem("redo", new Redo());
			}
			if (Util.isAddable(widget)) {
				bar.addItem("import", new Import());
			}
		} else {
			if (resizeMode != null) {
				bar.addItem("resizeModeOff", new ResizeModeOff());
			} else if (edit != null) {
				bar.addItem("ediOff", new EditOff());
			}
		}
		return bar;
	}

	private boolean isEditable(Widget widget) {
		if (Util.isCtlLabel(widget)) {
			return false;
		}
		if (widget instanceof HasHTML || widget instanceof Label) {
			return true;
		}
		if (widget instanceof FlexTable) {
			FlexTable table = (FlexTable) widget;
			WidgetServiceFT wft = (WidgetServiceFT) service;
			return !Util.isWidget(table, wft.getClikedAddr()[0], wft
					.getClikedAddr()[1]);
		}
		return false;
	}

	public void checkPoint() {
		isInCheckPoint = true;

		WidgetService ws = WidgetServiceFactory.getService(panel);
		Widget cl = ws.getClone();
		// 変わっていない場合はundoバッファーに入れない
		if (!isCloneSame) {
			rdStack.clear();
			udStack.push(cl);
			if (udStack.size() > maxundo) {
				udStack.remove(0);
			}
		}
		cPMap1 = cPMap2;
		cPMap2 = new HashMap();
		isCloneSame = true;
		isInCheckPoint = false;
	}

	/**
	 * Widgedをcloneに入れ替える<br>
	 * Alignの反映等のため
	 * 
	 * @param w
	 *            reset対象widget
	 * @return resetしたclone
	 */
	public Widget reset(Widget w) {
		isInCheckPoint = true;
		WidgetService ws = WidgetServiceFactory.getService(w);
		Widget pw = ws.getParent();
		WidgetService pws = WidgetServiceFactory.getService(pw);
		if (pws == null || ws == null) {
			return w;
		}
		Widget cl = ws.getClone();
		Util.resetToParent(w, pw, cl);
		importRec(panel);
		isInCheckPoint = false;
		return cl;
	}

	public class Add implements Command {
		private WidgetService addWs;

		public Add(WidgetService addWs) {
			super();
			this.addWs = addWs;
		}

		public void execute() {
			onFlightCmd = this;
			add(this.addWs);
			onFlightCmd = null;
		}
	}

	protected void add(WidgetService addWs) {
		// addは無条件でisCloneSame=false;
		isCloneSame = false;
		checkPoint();
		Widget w = addWs.getInstance();
		w = service.addWidget(addWs.setInitStyle(w));
		addWs.onAdd(this.widget);
		addListenerRec(w);
		pop.hide();
	}

	public class Remove implements Command {
		public void execute() {
			remove();
		}
	}

	protected void remove() {
		// removeは無条件でisCloneSame=false;
		isCloneSame = false;
		checkPoint();
		Widget pw = WidgetServiceFactory.getService(widget).getParent();
		WidgetService ws = WidgetServiceFactory.getService(pw);
		if (ws != null) {
			ws.removeWidget(widget);
			widget.unsinkEvents(DOM.getEventsSunk(widget.getElement()));
			DOM.setEventListener(widget.getElement(), null);
			elements.remove(widget.getElement());
		}
		if (pop != null) {
			pop.hide();
		}

	}

	protected DialogBox pdialog = null;

	public class Props implements Command {
		public void execute() {
			props();
		}
	}

	protected void props() {
		if (pdialog != null) {
			pdialog.hide();
		}
		pdialog = new PropDialog(widget, false);
		pdialog.show();
		pop.hide();

	}

	protected DialogBox apdialog = null;

	public class AllProps implements Command {
		public void execute() {
			allProps();
		}
	}

	protected void allProps() {
		if (apdialog != null) {
			apdialog.hide();
		}
		Widget target;
		if (widget == panel) {
			target = panel.getWidget();
			if (target == null) {
				return;
			}
		} else {
			target = widget;
		}
		apdialog = new PropDialog(target, true);
		apdialog.show();
		pop.hide();

	}

	public class Copy implements Command {
		public void execute() {
			isInCheckPoint = true;
			copy = service.getClone();
			isInCheckPoint = false;
			pop.hide();
		}
	}

	public class Cut implements Command {
		public void execute() {
			cut();
		}

	}

	protected void cut() {
		checkPoint();
		WidgetService pws = WidgetServiceFactory
				.getService(WidgetServiceFactory.getService(widget).getParent());
		pws.removeWidget(widget);
		copy = widget;
		pop.hide();
	}

	public class Paste implements Command {
		public void execute() {
			paste();
		}
	}

	protected void paste() {
		if (copy != null) {
			checkPoint();
			isInCheckPoint = true;
			WidgetService ws = WidgetServiceFactory.getService(copy);
			service.addWidget(ws.getClone());
			addListenerRec(widget);
			isInCheckPoint = false;
		}
		pop.hide();
	}

	public class ShowElement implements Command {
		public void execute() {
			DialogBox dialog = new DialogBox(true);
			TextArea ta = new TextArea();
			ta.setText(widget.getElement().toString().replaceAll(">", ">\n"));
			ta.setWidth("300px");
			ta.setHeight("500px");
			dialog.setWidget(ta);
			dialog.show();
			pop.hide();
		}
	}

	public class Undo implements Command {
		public void execute() {
			rdStack.push(panel);
			remove(panel);
			panel = (SimplePanel) udStack.pop();
			add(panel, DockPanel.CENTER);
			importRec(panel);
			pop.hide();
		}
	}

	public class Redo implements Command {
		public void execute() {
			udStack.push(panel);
			remove(panel);
			panel = (SimplePanel) rdStack.pop();
			add(panel, DockPanel.CENTER);
			importRec(panel);
			pop.hide();
		}
	}

	public class Import implements Command {
		public void execute() {
			srcBox = new DialogBox(false);
			ta = new TextArea();
			ta.setHeight("300px");
			ta.setWidth("300px");
			VerticalPanel vp = new VerticalPanel();
			srcBox.setWidget(vp);
			vp.add(ta);
			Button bt = new Button("import");
			bt.setStyleName("design-Button");
			bt.setWidth("80px");
			bt.addClickListener(new ClickListener() {
				public void onClick(Widget arg0) {
					Widget w = makeFromString(ta.getText());
					service.addWidget(w);
					importRec(w);
					srcBox.hide();
				}
			});
			Button bt2 = new Button("close");
			bt2.setStyleName("design-Button");
			bt2.setWidth("80px");
			bt2.addClickListener(new ClickListener() {
				public void onClick(Widget arg0) {
					srcBox.hide();
				}
			});
			HorizontalPanel hp_1 = new HorizontalPanel();
			hp_1.add(bt);
			hp_1.add(bt2);
			vp.add(hp_1);

			srcBox.setTitle("import");
			srcBox.setStyleName("design-dialog");
			srcBox.show();
			ta.setFocus(true);
		}
	}

	public class ResizeMode implements Command {
		public void execute() {
			resizeMode();
		}

	}

	protected void resizeMode() {
		setSizeExParent(WidgetServiceFactory.getService(widget).getParent(),
				true);
		checkPoint();
		resizeMode = setResizeToParent(widget);
		importRec(panel);
		if (pop != null) {
			pop.hide();
		}
	}

	public class ResizeModeOff implements Command {
		public void execute() {
			resizeModeOff();
		}
	}

	protected void resizeModeOff() {
		removeResize(resizeMode);
		resizeMode = null;
		importRec(panel);
		if (pop != null) {
			pop.hide();
		}
	}

	public class Edit implements Command {
		public void execute() {
			checkPoint();
			edit = widget;
			editMode(widget);
			importRec(panel);
			pop.hide();
		}
	}

	public class EditOff implements Command {
		public void execute() {
			if (edit instanceof HasHTML) {
				HasHTML hh = (HasHTML) edit;
				hh.setHTML(editTa.getText());
				Util.resetToParent(editTa, WidgetServiceFactory.getService(
						editTa).getParent(), (Widget) edit);
			} else if (edit instanceof HasText) {
				HasText ht = (HasText) edit;
				ht.setText(editTa.getText());
				Util.resetToParent(editTa, WidgetServiceFactory.getService(
						editTa).getParent(), (Widget) edit);
			} else if (edit instanceof FlexTable) {
				FlexTable ft = (FlexTable) edit;
				ft.setHTML(editAddr[0], editAddr[1], editTa.getText());
			}
			edit = null;
			editTa = null;
			importRec(panel);
			pop.hide();
		}
	}

	private void editMode(Widget editW) {
		editTa = new TextArea();
		if (editW instanceof FlexTable) {
			editTa.setWidth("100%");
			editTa.setHeight("100%");
		} else {
			editTa.setWidth(Util.getWidth(editW));
			editTa.setHeight(Util.getHeight(editW));
		}
		if (editW instanceof HasHTML) {
			HasHTML hh = (HasHTML) editW;
			editTa.setText(hh.getHTML());
		} else if (editW instanceof HasText) {
			HasText ht = (HasText) editW;
			editTa.setText(ht.getText());
		} else if (editW instanceof FlexTable) {
			FlexTable ft = (FlexTable) editW;
			WidgetServiceFT wft = (WidgetServiceFT) service;
			editAddr = wft.getClikedAddr();
			editTa.setText(ft.getText(editAddr[0], wft.getClikedAddr()[1]));
			ft.setWidget(editAddr[0], editAddr[1], editTa);
			return;
		}
		Util.resetToParent(editW, editW.getParent(), editTa);
	}

	protected RootWindowEx setResizeToParent(Widget removeW) {
		Widget parent = WidgetServiceFactory.getService(removeW).getParent();
		WidgetService pws = WidgetServiceFactory.getService(parent);
		HasWidgets hw = (HasWidgets) parent;
		Iterator it = hw.iterator();
		List l = new ArrayList();
		while (it.hasNext()) {
			l.add(it.next());
		}
		it = l.iterator();
		RootWindowEx ex = null;
		while (it.hasNext()) {
			Widget iw = (Widget) it.next();
			pws.setTargetInfo(parent, iw);
			if (iw == removeW) {
				ex = setResize(widget);
				pws.addWidget(ex);
			} else {
				pws.addWidget(iw);
			}
		}
		return ex;
	}

	/**
	 * resize対応
	 * 
	 * @param widget
	 * @return 対象のwidgetを含んだRootWindowEx
	 */
	protected RootWindowEx setResize(Widget widget) {
		RootWindowEx ro = new RootWindowEx();
		ResizableWindowEx re = new ResizableWindowEx(ro);
		re.setContent(widget);
		ro.add(re);
		if (ro == null) {
			return null;
		}
		return ro;
	}

	protected void removeResize(RootWindowEx widget) {
		Widget parent = widget.getParent();
		if (parent == null) {
			this.resizeMode = null;
			return;
		} else {
			setSizeExParent(parent, false);
		}
		Util.resetToParent(widget, parent, widget.getBaseWidget());
	}

	private void setSizeExParent(Widget widget, boolean b) {
		if (!(widget instanceof SimplePanel && BaseTitle.equals(widget
				.getTitle()))) {
			// WidgetService ws = WidgetServiceFactory.getService(widget);
			// Map fieldMap = ws.getPropMap();
			// List keys = new ArrayList(fieldMap.keySet());
			// Collections.sort(keys);
			// Iterator it = keys.iterator();
			// while (it.hasNext()) {
			// String key = (String) it.next();
			// if ("height".equals(key) || "width".equals(key)) {
			// Ltext lt = (Ltext) fieldMap.get(key);
			// String value = lt.getTextBox().getText();
			// if (b == true) {
			// setSizeEx(widget, key, value, "auto", value, value);
			// } else {
			// setSizeEx(widget, key, "", "", saveHeight, saveWidth);
			// }
			// }
			// }
			String value;
			if (b == true) {
				value = Util.getHeight(widget);
				setSizeEx(widget, "height", value, "auto", value, value);
				value = Util.getWidth(widget);
				setSizeEx(widget, "width", value, "auto", value, value);
			} else {
				setSizeEx(widget, "height", "", "", saveHeight, saveWidth);
				setSizeEx(widget, "width", "", "", saveHeight, saveWidth);
			}

		}
	}

	private void setSizeEx(Widget widget, String key, String save, String size,
			String height, String width) {
		if ("height".equals(key)) {
			if ("".equals(height)) {
				widget.setHeight(size);
			} else {
				saveHeight = save;
			}
		} else if ("width".equals(key)) {
			if ("".equals(width)) {
				widget.setWidth(size);
			} else {
				saveWidth = save;
			}
		}
	}

	protected void addListenerRec(Widget widget) {
		addListener(widget);
		if (widget instanceof HasWidgets) {
			HasWidgets hw = (HasWidgets) widget;
			Iterator it = hw.iterator();
			while (it.hasNext()) {
				Widget w = (Widget) it.next();
				addListenerRec(w);
			}
		}
	}

	protected List fields = new ArrayList();

	protected List code = new ArrayList();

	public String makeSource() {
		fields.clear();
		code.clear();
		flg = false;
		makeSource(panel);
		StringBuffer sb = new StringBuffer();
		fields.addAll(code);
		Iterator it = fields.iterator();
		while (it.hasNext()) {
			String s = (String) it.next();
			sb.append(s).append("\n");
		}
		return sb.toString();
	}

	protected boolean flg;

	protected void makeSource(Widget w) {
		List[] lists = new List[] { fields, code };
		WidgetService ws = WidgetServiceFactory.getService(w);
		if (ws == null) {
			return;
		}

		// BaseのSimplePanelはソースを作�?しな�?
		if (flg) {
			lists = ws.makeSource(lists, filedMap);
		}
		flg = true;
		fields = lists[0];
		code = lists[1];
		if (w instanceof HasWidgets) {
			HasWidgets hw = (HasWidgets) w;
			Iterator it = hw.iterator();
			while (it.hasNext()) {
				Widget w2 = (Widget) it.next();
				makeSource(w2);
			}
		}
	}

	protected DialogBox srcBox;

	private int cnt = 0;

	protected TextArea ta;

	public void onClick(Widget sender) {
		if (sender == this.srcBtn) {
			srcBox = new DialogBox(false);
			ta = new TextArea();
			ta.setHeight("300px");
			ta.setWidth("300px");
			ta.setText(makeSource() + "\n//css\n" + styleRules);
			VerticalPanel vp = new VerticalPanel();
			srcBox.setWidget(vp);
			vp.add(ta);
			Button bt = new Button("close");
			bt.setStyleName("design-Button");
			bt.setWidth("80px");
			bt.addClickListener(new ClickListener() {
				public void onClick(Widget arg0) {
					srcBox.hide();
				}
			});
			vp.add(bt);
			srcBox.setTitle("source code");
			srcBox.setText("source code");
			srcBox.setStyleName("design-dialog");
			srcBox.show();
			ta.setFocus(true);
			ta.selectAll();
		} else if (sender == this.rldBtn) {
			if (this.cssElm != null) {
				removeCss(this.cssElm);
			}
			this.cssElm = addCss(this.cssBox.getText() + "?" + cnt);
			cnt++;
			accessSessionCss("setAttribute");
			makeStylenames();
		} else if (sender == this.impBtn) {
			srcBox = new DialogBox(false);
			ta = new TextArea();
			ta.setHeight("300px");
			ta.setWidth("300px");
			VerticalPanel vp = new VerticalPanel();
			srcBox.setWidget(vp);
			vp.add(ta);
			Button bt = new Button("import");
			bt.setStyleName("design-Button");
			bt.setWidth("80px");
			bt.addClickListener(new ClickListener() {
				public void onClick(Widget arg0) {
					if (Window.confirm(wmsg)) {
						Widget w = makeFromString(ta.getText());
						importWidget(w);

						if (ta.getText().split("//css").length == 2) {
							importCss(ta.getText().split("//css")[1]);
						}
						srcBox.hide();
					}
				}
			});
			Button bt2 = new Button("close");
			bt2.setStyleName("design-Button");
			bt2.setWidth("80px");
			bt2.addClickListener(new ClickListener() {
				public void onClick(Widget arg0) {
					srcBox.hide();
				}
			});
			HorizontalPanel hp_1 = new HorizontalPanel();
			hp_1.add(bt);
			hp_1.add(bt2);
			vp.add(hp_1);

			srcBox.setTitle("import");
			srcBox.setText("import");
			srcBox.setStyleName("design-dialog");
			srcBox.show();
			ta.setFocus(true);
		} else if (sender == this.cssBtn) {

			srcBox = new DialogBox(false, false);
			ta = new TextArea();
			ta.setHeight("300px");
			ta.setWidth("300px");

			VerticalPanel vp = new VerticalPanel();
			srcBox.setWidget(vp);
			vp.add(ta);
			Button bt = new Button("add style");
			bt.setStyleName("design-Button");
			bt.setWidth("80px");

			ta.setText(styleRules);

			bt.addClickListener(new ClickListener() {
				public void onClick(Widget arg0) {
					importCss(ta.getText());
				}
			});
			Button bt2 = new Button("close");
			bt2.setStyleName("design-Button");
			bt2.setWidth("80px");
			bt2.addClickListener(new ClickListener() {
				public void onClick(Widget arg0) {
					srcBox.hide();
				}
			});
			HorizontalPanel hp_1 = new HorizontalPanel();
			hp_1.add(bt);
			hp_1.add(bt2);
			vp.add(hp_1);

			srcBox.setTitle("add style");
			srcBox.setText("add style");
			srcBox.setStyleName("design-dialog");
			srcBox.show();
			ta.setFocus(true);
		} else if (sender == this.opnBtn) {
			FileServicePanel fileServicePanel = new FileServicePanel();
			int left = opnBtn.getAbsoluteLeft() - 250;
			int top = opnBtn.getAbsoluteTop() - 50;
			fileServicePanel.button.setText(((Button) sender).getText());
			fileServicePanel.setPopupPosition(left, top);
			fileServicePanel.show();
		} else if (sender == this.savBtn) {
			saveDesign();
		} else if (sender == this.clrBtn) {
			if (this.panel.getWidget() != null) {
				this.widget = this.panel.getWidget();
				new Remove().execute();
			}
		}
	}

	public Widget getCopy() {
		return copy;
	}

	public Element addCss(String url) {

		Element e = DOM.createElement("link");
		DOM.setElementAttribute(e, "rel", "stylesheet");
		DOM.setElementAttribute(e, "href", url);
		DOM.setElementAttribute(e, "type", "text/css");
		// DOM.removeChild(DOM.getParent(this.getElement()),this.getElement());
		DOM.appendChild(RootPanel.get().getElement(), e);
		return e;
	}

	private void removeCss(Element element) {
		DOM.removeChild(DOM.getParent(element), element);
	}

	public Command getOnFlightCmd() {
		return onFlightCmd;
	}

	public PopupPanel getPop() {
		return pop;
	}

	public boolean isInCheckPoint() {
		return isInCheckPoint;
	}

	protected Widget instanceByString(String constracter, List serviceList,
			Map map) {
		Iterator it = serviceList.iterator();
		while (it.hasNext()) {
			WidgetService ws = (WidgetService) it.next();
			Widget inst = ws.getInstance(constracter, map);
			if (inst != null) {
				return inst;
			}
		}
		return null;
	}

	public static final String objNameKey = "objNameKey";

	protected Widget makeFromString(String s) {
		isInCheckPoint = true;
		List serviceList = WidgetServiceFactory.makeServiceList(null, null);
		s = s.replaceAll("\t", "").replaceAll("\r", "").replaceAll("\"\\+\n\"",
				"");
		List l = Util.devideStr(s, '\n');
		Iterator it = l.iterator();
		Widget base = null;
		Map map = new HashMap();
		Map subMethodMap = new HashMap();
		while (it.hasNext()) {
			String row = (String) it.next();
			row = row.trim().replaceAll("\t", "").replaceAll("\r", "");
			int newix = row.indexOf(" new ");
			if (newix == -1) {
				newix = row.indexOf(".make");
			}
			int eqix = row.indexOf('=');
			int prix = row.indexOf('.');
			if (newix != -1 && eqix != -1) {
				Widget w = instanceByString(row.substring(newix + 5),
						serviceList, map);
				if (w != null) {
					String obj = row.substring(0, eqix - 1).trim();
					map.put(obj, w);
					if (base == null) {
						base = w;
					}
				}
			}
			if (newix == -1 && eqix != -1) {
				String key = row.substring(eqix + 1).trim();
				key = key.substring(0, key.indexOf('.'));
				Widget w = (Widget) map.get(key);
				if (w != null) {
					String obj = row.substring(0, eqix - 1).trim();
					map.put(obj, w);
					String subMethd = row.substring(row.indexOf('.') + 1)
							.replaceAll("\\(.*", "").replaceAll(";", "")
							.replaceAll("\r", "");
					subMethodMap.put(obj, subMethd);
				}
			} else if (prix != -1) {
				String obj = row.substring(0, prix).trim();
				Widget w = (Widget) map.get(obj);
				String mt = row.substring(prix + 1);
				String sub = (String) subMethodMap.get(obj);
				if (sub != null) {
					int pi = mt.indexOf('(');
					mt = mt.substring(0, pi) + sub + mt.substring(pi);
				}
				WidgetService ws = WidgetServiceFactory.getService(w);
				if (ws != null) {
					ws.execByString(mt, map);
				}
			}
		}
		isInCheckPoint = false;
		return base;
	}

	public class FileServicePanel extends DialogBox implements FormHandler {

		private FormPanel formPanel = new FormPanel();

		private VerticalPanel verticalPanel = new VerticalPanel();

		private FileUpload fileUpload = new FileUpload();

		private Button button = new Button();

		FileServicePanel() {
			super(true);

			verticalPanel
					.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
			verticalPanel
					.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
			verticalPanel.setSize("450", "80");

			fileUpload.setWidth("400");
			fileUpload.setName("uploadFile");
			verticalPanel.add(fileUpload);

			button.addClickListener(new ClickListener() {
				public void onClick(Widget sender) {
					if (fileUpload.getFilename() != "" && Window.confirm(wmsg)) {

						// ファイルのアップロードを利用して,
						// ファイルの文字列をsessionに格納する
						// サーバー対応
						formPanel.setAction(Util.getServerContextURL()
								+ "openFile");
						formPanel.setMethod(FormPanel.METHOD_POST);
						formPanel.setEncoding(FormPanel.ENCODING_MULTIPART);
						formPanel.submit();
					}
				}
			});
			button.setStyleName("design-Button");
			verticalPanel.add(button);

			formPanel.add(verticalPanel);
			formPanel.addFormHandler(this);

			setWidget(formPanel);
			setTitle("open file");
			setText("open file");
			setStyleName("design-dialog");
		}

		public void onSubmit(FormSubmitEvent event) {
		}

		public void onSubmitComplete(FormSubmitCompleteEvent event) {

			// sessionに格納された文字列からwidgetを生成する
			SessionServiceAsync proxy = (SessionServiceAsync) GWT
					.create(SessionService.class);
			ServiceDefTarget entrypoint = (ServiceDefTarget) proxy;
			String entryURL = GWT.getModuleBaseURL();
			entrypoint.setServiceEntryPoint(entryURL + "getAttribute");
			AsyncCallback callback;

			callback = new AsyncCallback() {
				public void onFailure(Throwable caught) {
				}

				public void onSuccess(Object result) {
					Widget w = makeFromString(result.toString());
					importWidget(w);

					if (result.toString().split("//css").length == 2) {
						importCss(result.toString().split("//css")[1]);
					}

					hide();
				}
			};
			proxy.getAttribute("filesource", callback);
		}
	}

	/**
	 * Designの保存
	 */
	private void saveDesign() {

		// sourceをsessionに保持するためにRPCを使う
		SessionServiceAsync proxy = (SessionServiceAsync) GWT
				.create(SessionService.class);
		ServiceDefTarget entrypoint = (ServiceDefTarget) proxy;
		String entryURL = GWT.getModuleBaseURL();
		entrypoint.setServiceEntryPoint(entryURL + "setAttribute");
		AsyncCallback callback = new AsyncCallback() {

			public void onFailure(Throwable caught) {
				Window.alert(caught.toString());
			}

			public void onSuccess(Object result) {
				// txt保存させるservletの呼び出し
				Frame frame = new Frame(Util.getServerContextURL() + "getFile");
				frame.setVisible(false);
				((Panel) designPanel.getParent()).add(frame);
			}
		};
		proxy.setAttribute("designsource", makeSource() + "\n//css\n"
				+ styleRules, callback);
	}

	public Map getWidetCnts() {
		return widetCnts;
	}

	/**
	 * sessionにcss情報を保持,取得する
	 * 
	 * @param methodName
	 */
	private void accessSessionCss(String methodName) {

		SessionServiceAsync proxy = (SessionServiceAsync) GWT
				.create(SessionService.class);
		ServiceDefTarget entrypoint = (ServiceDefTarget) proxy;
		String entryURL = GWT.getModuleBaseURL();
		entrypoint.setServiceEntryPoint(entryURL + methodName);
		AsyncCallback callback;

		if ("getAttribute".equals(methodName)) {
			callback = new AsyncCallback() {
				public void onFailure(Throwable caught) {
				}

				public void onSuccess(Object result) {
					if (!"".equals(result.toString())) {
						cssBox.setText(result.toString());
					}
				}
			};
			proxy.getAttribute("cssElm", callback);
		} else if ("setAttribute".equals(methodName)) {
			callback = new AsyncCallback() {
				public void onFailure(Throwable caught) {
				}

				public void onSuccess(Object result) {
				}
			};
			proxy.setAttribute("cssElm", cssBox.getText(), callback);
		}
	}

	public List getStyleNames() {
		return styleNames;
	}

	public boolean isAddable() {
		return resizeMode == null && edit == null;
	}

	private static native void disableContextMenu() /*-{
	 $doc.oncontextmenu = function() { return false; };
	 }-*/;

	public Map getPropMap() {
		return propMap;
	}

	public boolean isCloneSame() {
		return isCloneSame;
	}

	public void setCloneSame(boolean isCloneSame) {
		this.isCloneSame = isCloneSame;
	}

	public Map getCPMap1() {
		return cPMap1;
	}

	public Map getCPMap2() {
		return cPMap2;
	}

	private void importCss(String cssStr) {
		if (div == null) {
			div = DOM.createElement("div");
		}
		DOM.setInnerHTML(div, "<div style='display:none'>*</div><style>"
				+ cssStr + "</style>");
		DOM.appendChild(RootPanel.get().getElement(), div);
		makeStylenames();
		styleRules = cssStr;
	}

	protected static void setDesignPanel(DesignPanel designPanel) {
		DesignPanel.designPanel = designPanel;
	}

	public SimplePanel getBasePanel() {
		return panel;
	}

	public Widget getWidget() {
		return widget;
	}

	public void setWidget(Widget widget) {
		this.widget = widget;
	}
}
