/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import jp.co.kpscorp.gwt.client.design.delegate.HasHorizontalAlignmentDelegate;
import jp.co.kpscorp.gwt.client.design.delegate.HasVerticalAlignmentDelegate;
import jp.co.kpscorp.gwt.client.design.delegate.TableDelegate;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.HTMLTable.RowFormatter;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.HasVerticalAlignment.VerticalAlignmentConstant;

public abstract class FormatterPanel extends DialogBox {

	protected FlexTable table;

	protected DockPanel base;

	protected FlexTable baseFt;

	protected TableDelegate delegate;

	// 置換検索ダイアログ
	private ReplaceDialog rpdialog;

	public FormatterPanel(FlexTable table) {
		super(false, false);
		this.table = table;
		this.delegate = new TableDelegate(table);
		setStyleName("design-dialog");
		setText(getPanelTitle());
		setTitle(getPanelTitle());
		initPanel();
		setWidget(base);
	}

	protected void initPanel() {
		DockPanel dp_1;
		HorizontalPanel hp_1;
		Button bt_1;
		Button bt_2;
		Button bt_3;		// replaceボタン
		FlexTable ft_1;
		Label lb_1;
		Label lb_4;
		dp_1 = new DockPanel();
		dp_1.setSpacing(10);
		DOM.setElementAttribute(dp_1.getElement(), "style",
				"border-collapse:separate;border-spacing:10");
		dp_1.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
		dp_1.setVerticalAlignment(VerticalPanel.ALIGN_TOP);
		hp_1 = new HorizontalPanel();
		hp_1.setSpacing(10);
		DOM.setElementAttribute(hp_1.getElement(), "style",
				"border-collapse:separate;border-spacing:10");
		hp_1.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
		hp_1.setVerticalAlignment(VerticalPanel.ALIGN_TOP);
		dp_1.add(hp_1, DockPanel.NORTH);
		bt_1 = new Button();
		bt_1.setStyleName("design-Button");
		bt_1.setWidth("80px");
		bt_1.setHTML("close");
		hp_1.add(bt_1);
		bt_1.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				hide();
				// 置換検索ダイアログが表示されていたら同時に閉じる
				if(rpdialog != null){
					rpdialog.hide();
				}
			}
		});
		bt_2 = new Button();
		bt_2.setStyleName("design-Button");
		bt_2.setWidth("80px");
		bt_2.setHTML("set");
		hp_1.add(bt_2);
		bt_2.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				setProps();
			}
		});
		bt_3 = new Button();
		bt_3.setStyleName("design-Button");
		bt_3.setWidth("80px");
		bt_3.setHTML("replace");
		hp_1.add(bt_3);
		bt_3.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				// 置換検索ダイアログを開く
				if (rpdialog == null) {
					rpdialog = new ReplaceDialog(base);
				} else if (!rpdialog.getHaswidgets().equals(base)) {
					// replaceボタンが再押下時、検索対象が変化していた場合は入れ替える
					rpdialog.setHaswidgets(base);
				}
				// 表示位置指定
				rpdialog.setPopupPosition(base.getAbsoluteLeft() + base.getOffsetWidth()
						, base.getAbsoluteTop());
				rpdialog.show();
			}
		});
		ft_1 = new FlexTable();
		ft_1.setStyleName("design-table");
		dp_1.add(ft_1, DockPanel.NORTH);
		lb_1 = new Label();
		lb_1.setStyleName("design-whiteLabel");
		lb_1.setText(getRowTitle());
		ft_1.setWidget(0, 0, lb_1);
		for (int i = 0; i < getProps().length; i++) {
			String prop = getProps()[i];
			lb_4 = new Label();
			lb_4.setText(getSimplePropName(prop));
			lb_4.setStyleName("design-whiteLabel");
			lb_4.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
			ft_1.setWidget(0, i + 1, lb_4);
		}

		for (int i = 0; i < getCount(); i++) {
			Label lb_3;
			lb_3 = new Label();
			lb_3.setText(getRowLabel(i));
			ft_1.setWidget(1 + i, 0, lb_3);
			makeRow(ft_1, i);
		}
		RowFormatter rowFormatter = ft_1.getRowFormatter();
		rowFormatter.setStyleName(0, "design-tableHeader");

		// ------------------------------
		base = dp_1;
		baseFt = ft_1;
	}

	protected abstract String getRowLabel(int i);

	protected String getSimplePropName(String prop) {
		return delegate.getSimplePropName(prop);
	}

	protected abstract String getPanelTitle();

	protected abstract String getRowTitle();

	protected abstract int getCount();

	protected abstract String[] getProps();

	public DockPanel getBase() {
		return base;
	}

	protected void setCommonWidget(FlexTable ft_1, int i, int j, String prop) {
		Widget tb_3;
		if (prop.startsWith("stylePrimaryName") || prop.startsWith("styleName")) {
			MultiWordSuggestOracle so = new MultiWordSuggestOracle();
			so.addAll(DesignPanel.getInstance().getStyleNames());
			tb_3 = new SuggestBox(so);
		} else {
			tb_3 = new TextBox();
		}
		tb_3.setStyleName("gwt-TextBox");
		((HasText) tb_3).setText((String) delegate.getByCnt(prop, i));
		ft_1.setWidget(1 + i, j + 1, tb_3);
	}

	protected void makeRow(FlexTable ft_1, int i) {
		for (int j = 0; j < getProps().length; j++) {
			String prop = getProps()[j];
			if (prop.indexOf("verticalAlign") != -1) {
				ListBox ltb_1;
				ltb_1 = HasVerticalAlignmentDelegate.getVACSelect();
				ltb_1.setStyleName("gwt-TextBox");
				ft_1.setWidget(1 + i, j + 1, ltb_1);
				ltb_1.setSelectedIndex(Util.getIdex(
						HasVerticalAlignmentDelegate.vacs, delegate.getByCnt(
								prop, i)));
			} else if (prop.indexOf("horizontalAlign") != -1) {
				ListBox ltb_1;
				ltb_1 = HasHorizontalAlignmentDelegate.getHACSelect();
				ltb_1.setStyleName("gwt-TextBox");
				ft_1.setWidget(1 + i, j + 1, ltb_1);
				ltb_1.setSelectedIndex(Util.getIdex(
						HasHorizontalAlignmentDelegate.hacs, delegate.getByCnt(
								prop, i)));
			} else {
				setCommonWidget(ft_1, i, j, prop);
			}
		}
	}

	protected void setProps() {
		for (int i = 0; i < getCount(); i++) {
			for (int j = 0; j < getProps().length; j++) {
				String prop = getProps()[j];
				if (prop.indexOf("verticalAlign") != -1) {
					ListBox lb = (ListBox) baseFt.getWidget(1 + i, j + 1);
					VerticalAlignmentConstant vac = HasVerticalAlignmentDelegate.vacs[lb
							.getSelectedIndex()];
					if (vac != null) {
						delegate.setByCnt(prop, i, vac);
					}
				} else if (prop.indexOf("horizontalAlign") != -1) {
					ListBox lb = (ListBox) baseFt.getWidget(1 + i, j + 1);
					HorizontalAlignmentConstant vac = HasHorizontalAlignmentDelegate.hacs[lb
							.getSelectedIndex()];
					if (vac != null) {
						delegate.setByCnt(prop, i, vac);
					}
				} else {
					setCommonProps(i, j, prop);
				}
			}
		}
	}

	protected void setCommonProps(int i, int j, String prop) {
		HasText tb = (HasText) baseFt.getWidget(1 + i, j + 1);
		delegate.setByCnt(prop, i, tb.getText());
	}

}
