/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ImportTool {

	private DialogBox dc;

	public ImportTool(Widget widget) {
		this(widget, true);
	}

	private boolean generate;

	private Widget widget;

	public ImportTool(Widget widget, boolean generate) {
		super();
		this.generate = generate;
		this.widget = widget;
		DeferredCommand.addCommand(new Command() {
			public void execute() {
				init();
			}
		});
	}

	private void init() {
		DesignPanel dp = DesignPanel.getInstance();
		Button clbt = new Button("close");
		dc = new DialogBox(false, true);
		VerticalPanel vp = new VerticalPanel();
		dc.setTitle("Design");
		dc.setText("Design");
		clbt.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				dc.hide();
			}
		});
		TextArea ta = new TextArea();
		dc.setStyleName("design-dialog");
		if (generate) {
			ta.setHeight("300px");
			ta.setWidth("300px");
			vp.add(ta);
		} else {
			vp.add(dp);
		}
		vp.add(clbt);
		dc.setWidget(vp);
		dc.center();
		dp.importWidget(widget);
		if (generate) {
			ta.setText(dp.makeSource());
			ta.setFocus(true);
			ta.selectAll();
		}

	}

}
