/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * <strong>ラベルとTextBox（またはListBoxEx、TextArea等）が組になったPanel 。</strong>
 * <p>
 * 
 * @author Katsusuke
 * 
 */
public class Ltext extends SimplePanel {

	private Label label = new Label();

	private HasText textBox = new TextBox();

	private ListBox select;

	private VerticalPanel vp = new VerticalPanel();

	/**
	 * @param text
	 * 
	 */
	public Ltext(String text) {
		super();
		vp.add(label);
		vp.add((Widget) textBox);
		label.setText(text);
		add(vp);
	}

	/**
	 * Label部分を得る
	 * 
	 * @return
	 */
	public Label getLabel() {
		return label;
	}

	/**
	 * TextBoxの部分を得る
	 * 
	 * @return
	 */
	public HasText getTextBox() {
		return textBox;
	}

	/**
	 * textを設定する
	 * 
	 * @param text
	 */
	public void setText(String text) {
		Widget w = vp.getWidget(1);
		if (w instanceof HasText) {
			HasText tb = (HasText) w;
			tb.setText(text);
		} else if (w instanceof ListBox) {
			setTextToSelct(text);
		}
	}

	private void setTextToSelct(String key) {
		select.setSelectedIndex(-1);
		for (int i = 0; i < select.getItemCount(); i++) {
			String value = select.getValue(i);
			if (key.equals(value)) {
				select.setSelectedIndex(i);
			}
		}

	}

	/**
	 * ListBoxを得る
	 * 
	 * @return
	 */
	public ListBox getSelect() {
		return select;
	}

	/**
	 * ListBoxを設定する
	 * 
	 * @param select
	 */
	public void setSelect(ListBox select) {
		if (this.select != null) {
			vp.remove(this.select);
		}
		this.select = select;
		if (this.textBox != null) {
			vp.remove((Widget) this.textBox);
			this.textBox = null;
		}
		vp.add(select);
	}

	/**
	 * TextBoxの部分を設定する
	 * 
	 * @param textBox
	 */
	public void setTextBox(HasText textBox) {
		if (this.select != null) {
			vp.remove(this.select);
			this.select = null;
		}
		if (this.textBox != null) {
			vp.remove((Widget) this.textBox);
		}
		this.textBox = textBox;
		vp.add((Widget) textBox);
	}

	public String getValue() {
		if (this.select != null) {
			int i = this.select.getSelectedIndex();
			if (i >= 0) {
				return this.select.getValue(i);
			}
		}
		if (this.textBox != null) {
			return this.textBox.getText();
		}
		return "";
	}

}
