/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class PropDialog extends DialogBox {

	protected Widget widget;

	protected Button clbt = new Button("close");

	protected Button albt = new Button("setAll");

	protected Button refbt = new Button("refresh");

	protected ListBox propLBox = new ListBox();

	protected List propList = new ArrayList();

	protected List tblList = new ArrayList();

	protected String selLBox = "-all properties-";

	protected Map tables = new HashMap();

	protected int maxCol = 5;

	protected boolean recorsive;

	protected VerticalPanel vp;

	protected HorizontalPanel hp;

	// replaceボタン
	protected Button rpbt = new Button("replace");

	// 置換検索ダイアログ
	protected ReplaceDialog rpdialog;

	public PropDialog(Widget widget, boolean recorsive) {
		super(false, false);
		this.recorsive = recorsive;
		this.widget = widget;
		setStyleName("gwt-DialogBox");
		setStyleName("design-dialog2");
		WidgetService ws = WidgetServiceFactory.getService(widget);
		if (ws == null) {
			return;
		}
		setText("properties - " + ws.getLabel());
		setTitle("properties - " + ws.getLabel());
		hp = new HorizontalPanel();
		clbt.setStyleName("design-CloseButton");
		clbt.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				hide();
				// 置換検索ダイアログが表示されていたら同時に閉じる
				if (rpdialog != null) {
					rpdialog.hide();
				}
			}
		});
		albt.setStyleName("design-CloseButton");
		albt.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				setAllProps();
			}
		});
		refbt.setStyleName("design-CloseButton");
		refbt.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				initPanel();
			}
		});
		// all properties リスト表示
		propLBox.setStyleName("design-CloseButton");
		propLBox.addChangeListener(new ChangeListener() {
			public void onChange(Widget sender) {
				setHeight("0");
				makeProps();
			}
		});
		// replaceボタン
		rpbt.setStyleName("design-CloseButton");
		rpbt.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				// 置換検索ダイアログを開く
				if (rpdialog == null) {
					rpdialog = new ReplaceDialog(vp);
				} else if (!rpdialog.getHaswidgets().equals(vp)) {
					// replaceボタンが再押下時、検索対象が変化していた場合は入れ替える
					rpdialog.setHaswidgets(vp);
				}
				// 表示位置指定
				rpdialog.setPopupPosition(vp.getAbsoluteLeft()
						+ vp.getOffsetWidth(), vp.getAbsoluteTop());
				rpdialog.show();
			}
		});

		hp.add(clbt);
		hp.add(albt);
		hp.add(rpbt); // replaceボタン
		hp.add(refbt);
		if (this.recorsive) {
			hp.add(propLBox);
			hp.setCellWidth(clbt, "50");
			hp.setCellWidth(albt, "50");
			hp.setCellWidth(rpbt, "50");
			hp.setCellWidth(refbt, "50");
			hp.setWidth("700");
			hp
					.setCellHorizontalAlignment(propLBox,
							HorizontalPanel.ALIGN_RIGHT);
		}
		initPanel();
	}

	protected void initPanel() {
		vp = new VerticalPanel();
		vp.add(hp);
		tblList.clear();
		if (this.recorsive) {
			makeTables(widget, vp);
			if (propLBox.getItemCount() == 0) {
				propLBox.addItem(selLBox);
				Collections.sort(propList);
				for (Iterator it = propList.iterator(); it.hasNext();) {
					String str = (String) it.next();
					propLBox.addItem(str);
				}
			}
		} else {
			FlexTable ft = makeTable(widget);
			if (ft != null) {
				vp.add(ft);
			}
		}
		setWidget(vp);
		if (rpdialog != null && !rpdialog.getHaswidgets().equals(vp)) {
			// set/setAllボタン押下時、検索対象を入れ替える
			rpdialog.setHaswidgets(vp);
		}
	}

	private void makeTables(Widget widget, VerticalPanel vp) {
		FlexTable ft = makeTable(widget);
		if (ft != null) {
			vp.add(ft);
			tblList.add(ft);
		}
		if (widget instanceof HasWidgets) {
			HasWidgets hw = (HasWidgets) widget;
			Iterator it = hw.iterator();
			while (it.hasNext()) {
				Widget w = (Widget) it.next();
				makeTables(w, vp);
			}
		}
	}

	private FlexTable makeTable(Widget widget) {
		if (Util.isCtlLabel(widget)) {
			return null;
		}
		Map fieldMap = new HashMap();
		Button stbt = new Button("set");
		stbt.setStyleName("design-Button");
		FlexTable table = new FlexTable();
		WidgetService ws = WidgetServiceFactory.getService(widget);
		if (ws == null) {
			return null;
		}
		stbt.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				setProps(sender);
			}
		});
		Label wlb = new Label(ws.getLabel() + ":" + widget.getTitle());
		wlb.setStyleName("design-Wid-label");
		table.setWidget(0, 0, wlb);
		table.setWidget(0, 1, stbt);
		fieldMap = ws.getPropMap();
		List keys = new ArrayList(fieldMap.keySet());
		Collections.sort(keys);
		Iterator it = keys.iterator();
		int row = 1;
		int col = 0;
		while (it.hasNext()) {
			if (col >= maxCol) {
				col = 0;
				row++;
			}
			String key = (String) it.next();
			table.setWidget(row, col, (Widget) fieldMap.get(key));
			col++;
		}
		List l = new ArrayList();
		l.add(widget);
		l.add(fieldMap);
		tables.put(stbt, l);
		if (!propList.contains(ws.getLabel())) {
			propList.add(ws.getLabel());
		}
		return table;
	}

	protected void setProps(Widget sender) {
		DesignPanel dp = DesignPanel.getInstance();
		dp.checkPoint();
		List l = (List) tables.get(sender);
		Widget w = (Widget) l.get(0);
		// alignを即時反映するためにcloneに入れ替え
		WidgetService ws = WidgetServiceFactory.getService(w);
		ws.setPropMap((Map) l.get(1));
		Widget cl = dp.reset(w);
		if (this.widget == w) {
			this.widget = cl;
		}
		initPanel();
	}

	protected void setAllProps() {
		DesignPanel dp = DesignPanel.getInstance();
		dp.checkPoint();
		Iterator it = tables.values().iterator();
		while (it.hasNext()) {
			List l = (List) it.next();
			WidgetServiceFactory.getService((Widget) l.get(0)).setPropMap(
					(Map) l.get(1));
		}
		this.widget = dp.reset(this.widget);
		initPanel();
	}

	private void makeProps() {
		selLBox = propLBox.getItemText(propLBox.getSelectedIndex());
		Iterator it = tblList.iterator();
		FlexTable ft;
		String title = "";
		Map fMap = new HashMap();
		vp.clear();
		vp.add(hp);
		while (it.hasNext()) {
			Object obj = it.next();
			if (obj instanceof FlexTable) {
				ft = (FlexTable) obj;
				title = ft.getText(0, 0).substring(0,
						ft.getText(0, 0).indexOf(':'));
				if (title.equals(selLBox) || selLBox.equals("-all properties-")) {
					List l = (List) tables.get(ft.getWidget(0, 1));
					fMap = (Map) l.get(1);
					List keys = new ArrayList(fMap.keySet());
					Collections.sort(keys);
					Iterator ite = keys.iterator();
					int row = 1;
					int col = 0;
					while (ite.hasNext()) {
						if (col >= maxCol) {
							col = 0;
							row++;
						}
						String key = (String) ite.next();
						ft.setWidget(row, col, (Widget) fMap.get(key));
						col++;
					}
					vp.add(ft);
				}
			}
		}
	}
}
