package jp.co.kpscorp.gwt.client.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ReplaceDialog extends DialogBox implements ClickListener{

	// 検索文字列用ラベル
	private Label lbl_search = new Label("検索：");
	// 検索文字列用テキストボックス
	private TextBox txt_search = new TextBox();
	// 置換文字列用ラベル
	private Label lbl_replace = new Label("置換：");
	// 置換文字列用テキストボックス
	private TextBox txt_replace = new TextBox();;

	// 置換オプション1（大文字・小文字の区別用）
	private CheckBox chkbox1 = new CheckBox("大/小文字を区別する", false);;
	// 置換オプション2（単語全体） // *** 未実装 ***
//	private CheckBox chkbox2 = new CheckBox("単語全体", false);;

	// 実行ボタン
	private Button btn_rpexec = new Button("実行");
	// 閉じるボタン
	private Button btn_close = new Button("閉じる");

	// 検索対象
	private HasWidgets hasWidgets;

	private VerticalPanel vp_body = new VerticalPanel();

	// 検索文字列入力エリア
	private HorizontalPanel hp_seachinput = new HorizontalPanel();
	// 置換文字列入力エリア
	private HorizontalPanel hp_replaceinput = new HorizontalPanel();
	// 検索オプションエリア
	private FlexTable ft_option = new FlexTable();
	// ボタンエリア
	private HorizontalPanel hp_button = new HorizontalPanel();

	/***************************************************************************
	 * 置換検索ダイアログ生成
	 ***************************************************************************/
	public ReplaceDialog(Widget widget) {
		super(false, false);
		hasWidgets = (HasWidgets) widget;

		setWidget(vp_body);
		setText("置換検索");
		setTitle("置換検索");

		// 検索文字列入力
		hp_seachinput.add(lbl_search);
		hp_seachinput.add(txt_search);
		vp_body.add(hp_seachinput);

		// 置換文字列入力
		hp_replaceinput.add(lbl_replace);
		hp_replaceinput.add(txt_replace);
		vp_body.add(hp_replaceinput);

		// 検索オプション
		ft_option.setWidget(0, 0, chkbox1);
//*		ft_option.setWidget(1, 0, chkbox2);
		vp_body.add(ft_option);

		// 置換ボタン
		btn_rpexec.setWidth("80px");
		btn_rpexec.setStyleName("design-Button");
		btn_rpexec.addClickListener(this);
		hp_button.add(btn_rpexec);

		// 閉じるボタン
		btn_close.setWidth("80px");
		btn_close.setStyleName("design-Button");
		btn_close.addClickListener(this);
		hp_button.add(btn_close);

		vp_body.add(hp_button);

		setTitle("Search or Replace");
		setStyleName("design-dialog");
	}

	/***************************************************************************
	 * テキストボックス・サジェストボックスの内容を置換する
	 ***************************************************************************/
	private void replaceText(){
		if(txt_search != null && txt_search != null){
			List list = new ArrayList();
			// 置換対象抽出
			makeTextList(list, hasWidgets);

			if(list != null){
				Iterator it = list.iterator();
				int cnt = 0;		//変更件数

				while (it.hasNext()){
					Widget w = (Widget) it.next();
					HasText text = (HasText) w;
//*					if(chkbox2.isChecked()){
						// 完全一致の場合
						if(chkbox1.isChecked() && text.getText().equals(txt_search.getText())){
							// 大/小文字を区別する場合
							text.setText(txt_replace.getText());
							cnt++;
						}else if(!chkbox1.isChecked() && text.getText().equalsIgnoreCase(txt_search.getText())){
							// 大/小文字を区別しない場合
							text.setText(txt_replace.getText());
							cnt++;
						}
// ****** 未実装 *************************
//					} else {
//						// 部分一致の場合
//						text.setText(text.getText().replaceAll(txt_search.getText(), txt_replace.getText()));
//						cnt++;
//					}
// ***************************************
				}

				// 終了時のメッセージ
				if(cnt == 0){
					Window.alert("文字列が見つかりませんでした。");
				}else {
					Window.alert("置換終了");
				}
			}
		}
	}

	/***************************************************************************
	 * 置換検索画面のクリックイベント処理
	 ***************************************************************************/
	public void onClick(Widget sender) {
		if(sender == btn_rpexec){
			// 置換ボタン押下時
			replaceText();
		}else if(sender == btn_close){
			// 閉じるボタン押下時
			hide();
		}
	}

	/***************************************************************************
	 * ウィジェットからテキストボックス・サジェストボックスをリストに抽出する。
	 ***************************************************************************/
	private void makeTextList(List l, HasWidgets widget) {
		Iterator itx = widget.iterator();
		while (itx.hasNext()) {
			Widget w = (Widget) itx.next();

			if (w instanceof TextBox || w instanceof SuggestBox) {
				//リストに追加
				l.add(w);
			} else if (w instanceof HasWidgets)
				//再帰処理
				makeTextList(l, (HasWidgets) w);
		}
	}

	/****************************************************************************
	 * 検索対象を再設定                                                         *
	 ****************************************************************************/
	public void setHaswidgets(HasWidgets hasWidgets){
		this.hasWidgets = hasWidgets;
	}

	/****************************************************************************
	 * 検索対象を取得                                                           *
	 ****************************************************************************/
	public HasWidgets getHaswidgets(){
		return hasWidgets;
	}
}
