/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;


import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class RowColDialog extends DialogBox {

	private FlexTable table;

	private int row;

	private int col;

	public RowColDialog(FlexTable table, int row, int col) {
		super(false, true);
		this.table = table;
		this.row = row;
		this.col = col;
		init();
	}

	private TextBox tb_1;

	private TextBox tb_2;

	private void init() {
		VerticalPanel vp_1;
		HorizontalPanel hp_1;
		VerticalPanel vp_2;
		Label lb_1;
		Label lb_2;
		VerticalPanel vp_3;
		Label lb_3;
		Button bt_1;
		vp_1 = new VerticalPanel();
		vp_1.setStyleName("design-newpanel");
		vp_1.setSpacing(10);
		DOM.setElementAttribute(vp_1.getElement(), "style",
				"border-collapse:separate;border-spacing:10");
		vp_1.setHorizontalAlignment(VerticalPanel.ALIGN_CENTER);
		hp_1 = new HorizontalPanel();
		hp_1.setSpacing(5);
		DOM.setElementAttribute(hp_1.getElement(), "style",
				"border-collapse:separate;border-spacing:5");
		hp_1.setVerticalAlignment(HorizontalPanel.ALIGN_MIDDLE);
		vp_1.add(hp_1);
		vp_2 = new VerticalPanel();
		vp_2.setSpacing(10);
		hp_1.add(vp_2);
		lb_1 = new Label();
		lb_1.setText("row");
		vp_2.add(lb_1);
		tb_1 = new TextBox();
		tb_1.setStyleName("gwt-TextBox");
		tb_1.setWidth("20px");
		tb_1.setText(row + "");
		vp_2.add(tb_1);
		lb_2 = new Label();
		lb_2.setText("x");
		hp_1.add(lb_2);
		vp_3 = new VerticalPanel();
		vp_3.setSpacing(10);
		hp_1.add(vp_3);
		lb_3 = new Label();
		lb_3.setText("col");
		vp_3.add(lb_3);
		tb_2 = new TextBox();
		tb_2.setStyleName("gwt-TextBox");
		tb_2.setHeight("");
		tb_2.setWidth("20px");
		tb_2.setText(col + "");
		vp_3.add(tb_2);
		bt_1 = new Button();
		bt_1.setStyleName("gwt-Button");
		bt_1.setWidth("50px");
		bt_1.setText("set");
		vp_1.add(bt_1);
		bt_1.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				int[] size = getSize();
				Util.removeLabel(table);
				setLabels(size[0], size[1]);
				hide();
			}
		});
		setWidget(vp_1);
		setStyleName("design-dialog");
	}

	private void setLabels(int row, int col) {
		for (int i = 0; i < row; i++) {
			if (table.getRowCount() <= i || table.getCellCount(i) <= col - 1
					|| table.getWidget(i, col - 1) == null) {
				table.setText(i, col - 1, "row" + i);
			}
		}
	}

	public int[] getSize() {
		int[] size = new int[2];
		tb_1.setText((size[0] = parse(tb_1.getText())) + "");
		tb_2.setText((size[1] = parse(tb_2.getText())) + "");
		return size;
	}

	private int parse(String s) {
		try {
			return Integer.parseInt(s);
		} catch (NumberFormatException e) {
			return 3;
		}
	}

}
