/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.delegate.BaseDelegate;
import jp.co.kpscorp.gwt.client.design.delegate.HasHorizontalAlignmentDelegate;
import jp.co.kpscorp.gwt.client.design.delegate.HasVerticalAlignmentDelegate;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.HasVerticalAlignment.VerticalAlignmentConstant;

public class Util {
	public static Label findLabel(HasWidgets hw) {
		Iterator it = hw.iterator();
		while (it.hasNext()) {
			Widget w = (Widget) it.next();
			if (isCtlLabel(w)
			// loop対策
					&& w.getParent() == hw) {
				Label lb = (Label) w;
				return lb;
			}
		}
		return null;
	}

	public static boolean isCtlLabel(Widget widget) {
		return (widget instanceof Label && BaseDelegate.lbstyle.equals(widget
				.getStyleName()));

	}

	public static void removeLabel(HasWidgets hw) {
		Label lb = null;
		while (!((lb = findLabel(hw)) == null)) {
			if (DOM.getParent(lb.getElement()) == null) {
				// null pointer 対策
				lb.setStyleName("");
			} else {
				hw.remove(lb);
			}
		}
	}

	public static String getHeight(Widget widget) {
		return DOM.getStyleAttribute(widget.getElement(), "height");
	}

	public static String getWidth(Widget widget) {
		return DOM.getStyleAttribute(widget.getElement(), "width");
	}

	public static boolean isAddable(Widget widget) {
		if (!DesignPanel.getInstance().isAddable()) {
			return false;
		}
		WidgetService ws = WidgetServiceFactory.getService(widget);
		if (ws != null) {
			return ws.isAddable();
		}
		return false;
	}

	public static int getIdex(Object[] os, Object o) {
		for (int i = 0; i < os.length; i++) {
			if (o == null) {
				if (os[i] == null) {
					return i;
				}
			} else if (o.equals(os[i])) {
				return i;
			}
		}
		return -1;
	}

	public static void addPropToFieldMap(String name, Map map, Object value) {
		Ltext lt = new Ltext(name);
		if (value instanceof String) {
			lt.getTextBox().setText((String) value);
		} else if (value instanceof ListBox) {
			lt.setSelect((ListBox) value);
		}
		map.put(name, lt);
	}

	public static int safeParse(Object s) {
		if (s instanceof Integer) {
			Integer ig = (Integer) s;
			return ig.intValue();
		}
		int i = 0;
		try {
			i = Integer.parseInt((String) s);
		} catch (Exception e) {
		}
		return i;
	}

	public static List[] makeAddCode(Widget widget, List[] lists, Map map,
			String fn) {
		Widget wp = WidgetServiceFactory.getService(widget).getParent();
		String parent = (String) map.get(wp);
		if (parent != null) {
			WidgetService pws = WidgetServiceFactory.getService(wp);
			if (pws == null) {
				pws = WidgetServiceFactory.getService(new SimplePanel());
			}
			String addcode = pws.getAddCode(widget, lists, parent, fn, map);
			if (addcode != null) {
				lists[1].add(addcode);
			}
		}
		map.put(widget, fn);
		return lists;
	}

	public static String getFieldName(List l, String fstr, String obstr) {
		Iterator it = l.iterator();
		int i = 0;
		while (it.hasNext()) {
			String s = (String) it.next();
			if (s.startsWith(fstr)) {
				String sf = s.substring(s.lastIndexOf("_") + 1, s.length() - 1);
				i = Integer.parseInt(sf);
			}
		}
		return obstr + "_" + (i + 1);
	}

	public static String makeSetterName(String prop) {
		return "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
	}

	public static String makeGetterName(String prop) {
		return "get" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
	}

	public static String makeGetterName(String prop, boolean isBoolean) {
		if (isBoolean) {
			return "is" + prop.substring(0, 1).toUpperCase()
					+ prop.substring(1);

		}
		return "get" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
	}

	public static String getPropName(String methodName) {
		if (methodName.startsWith("is") && methodName.length() > 2) {
			return methodName.substring(2, 3).toLowerCase()
					+ methodName.substring(3);
		}
		if (methodName.length() < 4) {
			return null;
		}
		return methodName.substring(3, 4).toLowerCase()
				+ methodName.substring(4);
	}

	/**
	 * Strimgを特定の文字を区切りとして分割する ()内は区切らない
	 * 
	 * @param s
	 * @param c
	 * @return
	 */
	public static List devideStr(String s, int c) {
		List l = new ArrayList();
		int cnt = 0;
		int bg = 0;
		for (int i = 0; i < s.length(); i++) {
			char ch = s.charAt(i);
			if (ch == '(') {
				cnt++;
			} else if (ch == ')') {
				cnt--;
			} else if (ch == c && cnt == 0) {
				l.add(s.substring(bg, i));
				bg = i + 1;
			}
		}
		l.add(s.substring(bg));
		// String subs = s;
		// List l = new ArrayList();
		// while (subs.indexOf(c) > -1) {
		// int i = subs.indexOf(c);
		// if (i > 0) {
		// l.add(subs.substring(0, i));
		// }
		// subs = subs.substring(i + 1);
		// }
		// if (subs.length() > 0) {
		// l.add(subs);
		// }
		return l;
	}

	public static void setSpacing(CellPanel cp, int spacing) {
		cp.setSpacing(spacing);
		DOM.setElementAttribute(cp.getElement(), "style",
				"border-collapse:separate;border-spacing:" + spacing);
	}

	public static String getNewTag(String tag) {
		Map map = DesignPanel.getInstance().getWidetCnts();
		Integer cnt = (Integer) map.get(tag);
		int i;
		if (cnt == null) {
			i = 1;
		} else {
			i = cnt.intValue();
			i++;
		}
		map.put(tag, new Integer(i));
		return tag + i;
	}

	public static VerticalAlignmentConstant getVerticalAlign(Element elem) {
		String s = DOM.getStyleAttribute(elem, "verticalAlign");
		if (s != null) {
			for (int i = 0; i < HasVerticalAlignmentDelegate.vacs.length; i++) {
				VerticalAlignmentConstant vac = HasVerticalAlignmentDelegate.vacs[i];
				if (vac != null
						&& s.toUpperCase().indexOf(
								vac.getVerticalAlignString().toUpperCase()) != -1) {
					return vac;
				}
			}
		}
		return null;
	}

	public static HorizontalAlignmentConstant getHorizontalAlign(Element elem) {
		String s = DOM.getStyleAttribute(elem, "horizontalAlign");
		for (int i = 0; i < HasHorizontalAlignmentDelegate.hacs.length; i++) {
			HorizontalAlignmentConstant hac = HasHorizontalAlignmentDelegate.hacs[i];
			if (s != null
					&& s.toUpperCase().indexOf(
							hac.getTextAlignString().toUpperCase()) != -1) {
				return hac;
			}
		}
		return null;
	}

	public static int[] getAddrOfTable(HTMLTable table, Widget w) {
		for (int i = 0; i < table.getRowCount(); i++) {
			for (int j = 0; j < table.getCellCount(i); j++) {
				Widget tw = table.getWidget(i, j);
				if (tw == w) {
					return new int[] { i, j };
				}
			}
		}
		return null;
	}

	public static native String getSelectorTexts() /*-{
	 var shs = window.parent.document.styleSheets;
	 var res;
	 for (i = 0; i < shs.length; i++) {
	 rls = shs[i].rules;
	 if (rls == null) {
	 rls = shs[i].cssRules;
	 }
	 for (j = 0; j < rls.length; j++) {
	 res = res+"," +rls[j].selectorText;
	 }
	 }
	 return res;
	 }-*/;

	public static String getServerContextURL() {
		// GWT提供のTomcatの場合GWT.getModuleBaseURL()は使用しない
		if (GWT.getModuleBaseURL().indexOf("8888") != -1) {
			return "/";
		} else {
			return GWT.getModuleBaseURL();
		}
	}

	/**
	 * 順番を維持したまま、parentのremoveWをwidgetに入れ替える
	 * 
	 * @param removeW
	 * @param parent
	 * @param widget
	 */
	public static Widget resetToParent(Widget removeW, Widget parent,
			Widget widget) {
		WidgetService pws = WidgetServiceFactory.getService(parent);
		HasWidgets hw = (HasWidgets) parent;
		Iterator it = hw.iterator();
		List l = new ArrayList();
		while (it.hasNext()) {
			l.add(it.next());
		}
		it = l.iterator();
		while (it.hasNext()) {
			Widget iw = (Widget) it.next();
			pws.setTargetInfo(parent, iw);
			pws.removeWidget(iw);
			if (iw == removeW || isIdEquals(iw, removeW)) {
				pws.addWidget(widget);
			} else {
				pws.addWidget(iw);
			}
		}
		return widget;
	}

	public static boolean isIdEquals(Widget w1, Widget w2) {
		String id1 = DOM.getElementProperty(w1.getElement(), "id");
		String id2 = DOM.getElementProperty(w2.getElement(), "id");
		if (id1 == null) {
			return false;
		}
		return id1.equals(id2);
	}

	public static boolean isWidget(FlexTable table, int row, int col) {
		String s = "";
		if (table.getRowCount() > row && table.getCellCount(row) > col) {
			s = table.getHTML(row, col);
		}
		return s.indexOf("widgetID") != -1;
	}

	public static Object nullSafe(Object o) {
		if (o == null) {
			return "<null>";
		}
		return o;
	}

	public static Widget getShallowCopy(Widget widget) {
		WidgetService ws = WidgetServiceFactory.getService(widget);
		if (ws == null) {
			return null;
		}
		Widget clone = ws.getInstance();
		WidgetService wscl = WidgetServiceFactory.getService(clone);
		if (wscl != null) {
			return wscl.shallowCopy(widget);
		}
		return null;
	}

	public static boolean contains(Object[] os, Object o) {
		if (o == null) {
			return false;
		}
		for (int i = 0; i < os.length; i++) {
			if (o.equals(os[i])) {
				return true;
			}
		}
		return false;
	}

	public static Object doGetter(WidgetService ws, String prop) {
		Object o = ws.exec(Util.makeGetterName(prop), null);
		if (o == null) {
			o = ws.exec(Util.makeGetterName(prop, true), null);
		}
		return o;

	}

}
