/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

public interface WidgetService {

	public List[] makeSource(List[] lists, Map map);

	public PopupPanel makeBar();

	public String getLabel();

	public String getTag();

	public String getFieldString();

	public String getInstanceString();

	public Widget getInstance();

	public Widget getInstance(String constracter, Map map);

	public Widget setInitStyle(Widget widget);

	public void setClickEvent(Event event);

	public Widget addWidget(Widget widget);

	public void onAdd(Widget parent);

	public void removeWidget(Widget widget);

	public Map getPropMap();

	public void setPropMap(Map fieldMap);

	public String getAddCode(Widget widget, List[] lists,
			String parentFiledName, String fieldName, Map map);

	public Object execByString(String s, Map objMap);

	public Widget getClone();

	public void setTargetInfo(Widget parent, Widget child);

	public boolean isAddable();

	public boolean isAddableToParent();

	public boolean isRemovableToParent();

	public List getProps();

	public List getInnerProps();

	public Object exec(String mthodName, Object[] parms);

	public Widget shallowCopy(Widget widget);

	public boolean isClickResize();

	public Widget getParent();

}
