/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;


import jp.co.kpscorp.gwt.client.design.delegate.HasHtmlDelegate;


import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;

public class WidgetServiceBT extends WidgetServiceBase {

	private String fieldString = "Button ";

	private String instanceString = " = new Button();";

	private String tag = "bt";
	
	private HasHtmlDelegate hasHtmlDelegate;

	public WidgetServiceBT(Widget widget, Widget parent) {
		super(widget, parent);
		hasHtmlDelegate = new HasHtmlDelegate(widget,this);
		delegates.add(hasHtmlDelegate);
		init(widget, parent);
	}

	public WidgetServiceBT(Widget widget) {
		this(widget, null);
	}


	public Widget getInstance() {
		return new Button();
	}

	public String getLabel() {
		return "Button";
	}

	public String getTag() {
		return tag;
	}


	public Widget setInitStyle(Widget widget) {
		Widget w = hasHtmlDelegate.setInitStyle(widget);
		w.setStyleName("design-Button");
		w.setWidth("80px");
		return w;
	}


	public String getInstanceString() {
		return instanceString;
	}

	public String getFieldString() {
		return fieldString;
	}


}
