/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.delegate.BaseDelegate;
import jp.co.kpscorp.gwt.client.design.delegate.Delegate;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class WidgetServiceBase implements WidgetService {

	protected BaseDelegate baseDelegate;

	protected Widget widget;

	protected List props = new ArrayList();

	protected List innerProps = new ArrayList();

	protected List delegates = new ArrayList();

	public WidgetServiceBase() {
		super();
	}

	public WidgetServiceBase(Widget widget, Widget parent) {
		super();
		this.widget = widget;
		baseDelegate = new BaseDelegate(this, widget, parent);
		delegates.add(baseDelegate);
		init(widget, parent);
	}

	protected void init(Widget widget, Widget parent) {
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			props.addAll(Arrays.asList(delegate.getProps()));
			innerProps.addAll(Arrays.asList(delegate.getInnerProps()));
		}
		// 重複を除く
		props = new ArrayList(new HashSet(props));
		innerProps = new ArrayList(new HashSet(innerProps));
	}

	public WidgetServiceBase(Widget widget) {
		this(widget, null);
	}

	public void setClickEvent(Event clickEvent) {
		baseDelegate.setClickEvent(clickEvent);
	}

	public PopupPanel makeBar() {
		return baseDelegate.makeBar();
	}

	public Widget addWidget(Widget widget) {
		baseDelegate.addWidget(widget);
		return widget;
	}

	public String getAddCode(Widget widget, List[] lists,
			String parentFiledName, String fieldName, Map map) {
		return baseDelegate.getAddCode(widget, lists, parentFiledName,
				fieldName, map);
	}

	public Widget getClone() {
		return baseDelegate.getClone();
	}

	public Widget setInitStyle(Widget widget) {
		return baseDelegate.setInitStyle(widget);
	}

	public void removeWidget(Widget widget) {
		baseDelegate.removeWidget(widget);
	}

	public Map getPropMap() {
		Map map = new HashMap();
		for (int i = 0; i < props.size(); i++) {
			String prop = (String) props.get(i);
			Ltext lt = getLtext(prop);
			if (lt != null) {
				map.put(prop, lt);
			}
		}
		return map;
	}

	public void setPropMap(Map fieldMap) {
		for (int i = 0; i < props.size(); i++) {
			String prop = (String) props.get(i);
			Ltext lt = (Ltext) fieldMap.get(prop);
			if (lt != null) {
				setLtext(prop, lt);
			}
		}
	}

	public void setTargetInfo(Widget parent, Widget child) {

	}

	public Object execByString(String s, Map objMap) {
		String mn = s.replaceFirst("\\(.*\\).*", "");
		// String ps = s.replaceAll(".*\\(", "").replaceAll("\\).*", "")
		// .replaceAll("\r", "");
		int st = s.indexOf('(') + 1;
		int en = s.lastIndexOf(')');
		if (en == -1) {
			en = s.length();
		}
		String ps = s.substring(st, en).replaceAll("\r", "");
		List l = Util.devideStr(ps, ',');
		Object[] os = new Object[l.size()];
		Iterator it = l.iterator();
		int i = 0;
		while (it.hasNext()) {
			String p = (String) it.next();
			Object o = objMap.get(p);
			if (o != null) {
				os[i] = o;
			} else {
				os[i] = getParmObj(p);
			}
			i++;
		}
		return exec(mn, os);
	}

	public List[] makeSource(List[] lists, Map map) {
		String fn = Util.getFieldName(lists[0], getFieldString(), getTag());
		lists[0].add(getFieldString() + fn + ";");
		lists[1].add(fn + getInstanceString());
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			delegate.makeSetterCode(widget, lists, getFieldString(),
					getInstanceString(), getTag(), fn, map);
		}
		return Util.makeAddCode(widget, lists, map, fn);
	}

	public Object exec(String mthodName, Object[] parms) {
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			Object o = delegate.exec(mthodName, parms);
			if (o != null) {
				return o;
			}
		}
		return null;
	}

	protected Object getParmObj(String parmStr) {
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			Object o = delegate.getParmObj(parmStr);
			if (o != null && o != parmStr) {
				return o;
			}
		}
		return parmStr;
	}

	protected Ltext getLtext(String prop) {
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			Ltext o = delegate.getLtext(prop);
			if (o != null) {
				return o;
			}
		}
		return null;
	}

	public void setLtext(String prop, Ltext ltext) {
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			delegate.setLtext(prop, ltext);
		}
	}

	protected List getDelegates() {
		return delegates;
	}

	public boolean isAddable() {
		return baseDelegate.isAddable();
	}

	public List getProps() {
		return props;
	}

	public Widget shallowCopy(Widget from) {
		return baseDelegate.shallowCopy(from);
	}

	public Widget getInstance(String constracter, Map map) {
		if (getInstanceString().indexOf(constracter.trim()) >= 0) {
			return getInstance();
		}
		return null;
	}

	public boolean isClickResize() {
		return baseDelegate.isClickResize();
	}

	public void onAdd(Widget parent) {
		// do nothing
	}

	public Widget getParent() {
		return this.widget.getParent();
	}

	public List getInnerProps() {
		return innerProps;
	}

	public boolean isAddableToParent() {
		return baseDelegate.isAddableToParent();
	}

	public boolean isRemovableToParent() {
		return baseDelegate.isRemovableToParent();
	}

}
