/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import jp.co.kpscorp.gwt.client.design.delegate.DockPanelDelegate;

import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

public class WidgetServiceDP extends WidgetServiceAlign {

	private String fieldString = "DockPanel ";

	private String instanceString = " = new DockPanel();";

	private String obstr = "dp";

	private DockPanelDelegate dockPanelDelegate;

	public WidgetServiceDP(Widget widget, Widget parent) {
		super(widget, parent);
		dockPanelDelegate = new DockPanelDelegate(widget);
		delegates.add(dockPanelDelegate);
		init(widget, parent);
	}

	public WidgetServiceDP(Widget widget) {
		this(widget, null);
	}

	public PopupPanel makeBar() {
		return dockPanelDelegate.makeBar();
	}

	public Widget getInstance() {
		return new DockPanel();
	}

	public String getLabel() {
		return "DockPanel";
	}

	public String getTag() {
		return obstr;
	}

	public String getInstanceString() {
		return instanceString;
	}

	public DockPanelDelegate getDockPanelDelegate() {
		return dockPanelDelegate;
	}

	public Widget addWidget(Widget widget) {
		dockPanelDelegate.addWidget(widget);
		return widget;
	}

	public String getAddCode(Widget widget, String parentFiledName,
			String fieldName) {
		return dockPanelDelegate.getAddCode(widget, parentFiledName, fieldName);
	}

	public Widget setInitStyle(Widget widget) {
		return dockPanelDelegate.setInitStyle(widget);
	}

	public void removeWidget(Widget widget) {
		dockPanelDelegate.removeWidget(widget);
	}

	public void setTargetInfo(Widget parent, Widget child) {
		dockPanelDelegate.setTargetInfo(parent, child);
	}

	public String getFieldString() {
		return fieldString;
	}

	public boolean isAddable() {
		return true;

	}

}
