/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import jp.co.kpscorp.gwt.client.design.delegate.TableDelegate;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

public class WidgetServiceFT extends WidgetServiceBase {

	private String fieldString = "FlexTable ";

	private String instanceString = " = new FlexTable();";

	private String tag = "ft";

	private TableDelegate tableDelegate;

	public WidgetServiceFT(Widget widget, Widget parent) {
		super(widget, parent);
		tableDelegate = new TableDelegate(widget);
		delegates.add(tableDelegate);
		init(widget, parent);
	}

	public WidgetServiceFT(Widget widget) {
		this(widget, null);
	}

	public Widget getInstance() {
		return tableDelegate.getInstance();
	}

	public String getLabel() {
		return "FlexTable";
	}

	public String getTag() {
		return tag;
	}

	public PopupPanel makeBar() {
		return tableDelegate.makeBar();
	}

	public void setClickEvent(Event clickEvent) {
		tableDelegate.setClickEvent(clickEvent);
	}

	public Widget addWidget(Widget widget) {
		tableDelegate.addWidget(widget);
		return widget;
	}

	public String getAddCode(Widget widget, String parentFiledName,
			String fieldName) {
		return tableDelegate.getAddCode(widget, parentFiledName, fieldName);
	}

	public Widget setInitStyle(Widget widget) {
		return tableDelegate.setInitStyle(widget);
	}

	public void removeWidget(Widget widget) {
		tableDelegate.removeWidget(widget);
	}

	public void setTargetInfo(Widget parent, Widget child) {
		tableDelegate.setTargetInfo(parent, child);
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	public boolean isAddable() {
		return true;
	}

	public int[] getClikedAddr() {
		return tableDelegate.getClikedAddr();
	}

	public Widget shallowCopy(Widget from) {
		return tableDelegate.shallowCopy(from);
	}
	
	

}
