/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import jp.co.kpscorp.gwt.client.design.delegate.HasHorizontalAlignmentDelegate;
import jp.co.kpscorp.gwt.client.design.delegate.HasHtmlDelegate;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;

public class WidgetServiceHT extends WidgetServiceBase {

	private String fieldString = "HTML ";

	private String instanceString = " = new HTML();";

	private String tag = "ht";

	private HasHtmlDelegate hasHtmlDelegate;

	public WidgetServiceHT(Widget widget, Widget parent) {
		super(widget, parent);
		hasHtmlDelegate = new HasHtmlDelegate(widget, this);
		delegates.add(hasHtmlDelegate);
		delegates.add(new HasHorizontalAlignmentDelegate(widget));
		init(widget, parent);
	}

	public WidgetServiceHT(Widget widget) {
		this(widget, null);
	}

	public Widget getInstance() {
		return new HTML();
	}

	public String getLabel() {
		return "HTML";
	}

	public String getTag() {
		return tag;
	}

	public Widget setInitStyle(Widget widget) {
		widget.setStyleName("design-newpanel");
		return hasHtmlDelegate.setInitStyle(widget);
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

}
