/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;


import jp.co.kpscorp.gwt.client.design.delegate.ImageDelegate;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class WidgetServiceIM extends WidgetServiceBase {

	private String fieldString = "Image ";

	private String instanceString = " = new Image();";

	private String tag = "im";

	private ImageDelegate imageDelegate;

	public WidgetServiceIM(Widget widget, Widget parent) {
		super(widget, parent);
		imageDelegate = new ImageDelegate(widget, this);
		delegates.add(imageDelegate);
		init(widget, parent);
	}

	public WidgetServiceIM(Widget widget) {
		this(widget, null);
	}

	public Widget getInstance() {
		return new Image();
	}

	public String getLabel() {
		return "Image";
	}

	public String getTag() {
		return tag;
	}

	public Widget setInitStyle(Widget widget) {
		return imageDelegate.setInitStyle(widget);
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}


}
