/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import jp.co.kpscorp.gwt.client.design.delegate.HasHorizontalAlignmentDelegate;
import jp.co.kpscorp.gwt.client.design.delegate.HasTextDelegate;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class WidgetServiceLB extends WidgetServiceBase {

	private String fieldString = "Label ";

	private String instanceString = " = new Label();";

	private String tag = "lb";

	private HasTextDelegate hasTextDelegate;

	public WidgetServiceLB(Widget widget, Widget parent) {
		super(widget, parent);
		hasTextDelegate = new HasTextDelegate(widget, this);
		delegates.add(hasTextDelegate);
		delegates.add(new HasHorizontalAlignmentDelegate(widget));
		init(widget, parent);
	}

	public WidgetServiceLB(Widget widget) {
		this(widget, null);
	}

	public Widget getInstance() {
		return new Label();
	}

	public String getLabel() {
		return "Label";
	}

	public String getTag() {
		return tag;
	}

	public Widget setInitStyle(Widget widget) {
		widget.setStyleName("design-newpanel");
		return hasTextDelegate.setInitStyle(widget);
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	public Widget addWidget(Widget widget) {
		// Labelにaddする場合は親にaddする
		WidgetService ws = WidgetServiceFactory.getService(this.widget
				.getParent());
		if (ws != null) {
			ws.addWidget(widget);
		}
		return widget;
	}

	public boolean isAddable() {
		// CtlLabelの場合は親へ委譲
		if (Util.isCtlLabel(widget)) {
			return Util.isAddable(widget.getParent());
		}
		return false;
	}

}
