/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design;

import jp.co.kpscorp.gwt.client.design.delegate.HasTextDelegate;

import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;

public class WidgetServiceTA extends WidgetServiceBase {

	private String fieldString = "TextArea ";

	private String instanceString = " = new TextArea();";

	private String tag = "ta";

	private HasTextDelegate hasTextDelegate;

	public WidgetServiceTA(Widget widget, Widget parent) {
		super(widget, parent);
		hasTextDelegate = new HasTextDelegate(widget, this);
		delegates.add(hasTextDelegate);
		init(widget, parent);
	}

	public WidgetServiceTA(Widget widget) {
		this(widget, null);
	}

	public Widget getInstance() {
		return new TextArea();
	}

	public String getLabel() {
		return "TextArea";
	}

	public String getTag() {
		return tag;
	}

	public Widget setInitStyle(Widget widget) {
		Widget w = hasTextDelegate.setInitStyle(widget);
		w.setHeight("80px");
		w.setWidth("120px");
		return w;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

}
