/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design.delegate;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.DesignPanel;
import jp.co.kpscorp.gwt.client.design.Ltext;
import jp.co.kpscorp.gwt.client.design.Util;
import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.Widget;

public class BaseDelegate implements Delegate {

	protected Widget widget;

	protected Widget parent;

	protected WidgetService service;

	protected Event clickEvent;

	public static final String lbstyle = "design-label";

	// protected String[] props = { "title", "styleName", "stylePrimaryName",
	// "width", "height", "spacing" };
	// firefox spacingを先にしないといけない
	protected String[] props = { "title", "spacing", "styleName", "width",
			"height" };

	public BaseDelegate() {
		super();
	}

	public BaseDelegate(WidgetService service, Widget widget, Widget parent) {
		super();
		this.widget = widget;
		this.parent = parent;
		this.service = service;
	}

	public PopupPanel makeBar() {
		MenuBar bar1 = new MenuBar(true);
		bar1 = makeBarSub(bar1);
		PopupPanel pop = new PopupPanel(true);
		pop.add(bar1);
		return pop;
	}

	protected MenuBar makeBarSub(MenuBar bar1) {
		DesignPanel dp = DesignPanel.getInstance();
		if (Util.isAddable(widget)) {
			MenuBar bar11 = dp.getAddBar();
			bar1.addItem("add", bar11);
		}
		bar1 = dp.addStandardBar(bar1, widget);
		return bar1;
	}

	public void addWidget(Widget widget) {
		if (this.widget instanceof HasWidgets) {
			HasWidgets hs = (HasWidgets) this.widget;
			Util.removeLabel(hs);
			hs.add(widget);
		}
	}

	public void removeWidget(Widget widget) {
		if (this.widget instanceof HasWidgets) {
			HasWidgets hs = (HasWidgets) this.widget;
			hs.remove(widget);
			if (!hs.iterator().hasNext()
					&& !DesignPanel.BaseTitle.equals(this.widget.getTitle())) {
				Label label = new Label(service.getTag());
				label.setStyleName(lbstyle);
				hs.add(label);
			}
		}
	}

	public String getAddCode(Widget widget, List[] lists,
			String parentFiledName, String fieldName, Map map) {
		return parentFiledName + ".add(" + fieldName + ");";
	}

	public void makeSetterCode(Widget widget, List[] lists, String fstr,
			String instr, String obstr, String fn, Map map) {
		for (int i = 0; i < getProps().length; i++) {
			String prop = getProps()[i];
			Object o;
			o = exec(Util.makeGetterName(prop), null);
			if (o == null) {
				o = exec(Util.makeGetterName(prop, true), null);
			}
			if (o != null && !"".equals(o.toString())) {
				lists[1].add(fn + "." + Util.makeSetterName(prop) + "("
						+ makeParmString(o) + ");");
				// 例外対応
				if ("setSpacing".equals(Util.makeSetterName(prop))) {
					// spacing firefox対応
					String spc = "DOM.setElementAttribute("
							+ fn
							+ ".getElement(), \"style\", \"border-collapse:separate;border-spacing:"
							+ makeParmString(o) + "\");";
					lists[1].add(spc);
				}
			}
		}
	}

	public String makeParmString(Object o) {
		if (o instanceof String) {
			String so = (String) o;
			return "\"" + so + "\"";
		} else if (o != null) {
			return o.toString();
		}
		return null;
	}

	public Widget setInitStyle(Widget widget) {
		WidgetService ws = WidgetServiceFactory.getService(widget);
		widget.setTitle(Util.getNewTag(ws.getTag()));
		if (widget instanceof HasWidgets) {
			widget.setStyleName("design-newpanel");
			Label label = new Label(widget.getTitle());
			label.setStyleName(lbstyle);
			ws.addWidget(label);
			if (widget instanceof CellPanel) {
				CellPanel cp = (CellPanel) widget;
				Util.setSpacing(cp, 10);
				cp.setWidth("100px");
				cp.setHeight("100px");
			}
		}
		return widget;

	}

	public void setClickEvent(Event clickEvent) {
		this.clickEvent = clickEvent;
	}

	public Widget getClone() {
		return getClone(widget);
	}

	private Widget getClone(Widget widget) {
		Widget clone = Util.getShallowCopy(widget);
		if (clone instanceof HasWidgets) {
			HasWidgets hw = (HasWidgets) widget;
			WidgetService clws = WidgetServiceFactory.getService(clone);
			Iterator it = hw.iterator();
			while (it.hasNext()) {
				Widget cw = (Widget) it.next();
				Widget cclone = WidgetServiceFactory.getService(cw).getClone();
				if (cclone != null) {
					clws.setTargetInfo(widget, cw);
					clws.addWidget(cclone);
				}
			}
		}
		return clone;
	}

	// public Widget getClone() {
	// return getClone(widget, null);
	// }
	//
	// private Widget getClone(Widget widget, Widget parent) {
	// Widget clone = Util.getShallowCopy(widget);
	// if (clone == null) {
	// return null;
	// }
	// WidgetService pws = WidgetServiceFactory.getService(parent);
	// if (pws != null) {
	// pws.setTargetInfo(parent, widget);
	// pws.addWidget(clone);
	// }
	// if (clone instanceof HasWidgets) {
	// HasWidgets hw = (HasWidgets) widget;
	// Iterator it = hw.iterator();
	// while (it.hasNext()) {
	// Widget cw = (Widget) it.next();
	// getClone(cw, clone);
	// }
	// }
	// return clone;
	// }

	public Object exec(String mthodName, Object[] parms) {
		try {
			String s = null;
			if (parms != null && parms[0] != null) {
				s = parms[0].toString();
			}
			if ("setStyleName".equals(mthodName)) {
				widget.setStyleName(s);
				return widget;
			} else if ("setStylePrimaryName".equals(mthodName)) {
				widget.setStylePrimaryName(s);
				return widget;
			} else if ("setWidth".equals(mthodName)) {
				widget.setWidth(s);
				return widget;
			} else if ("setHeight".equals(mthodName)) {
				widget.setHeight(s);
				return widget;
			} else if ("setTitle".equals(mthodName)) {
				widget.setTitle(s);
				return widget;
			} else if (widget instanceof CellPanel
					&& "setSpacing".equals(mthodName)) {
				CellPanel cp = (CellPanel) widget;
				Util.setSpacing(cp, Util.safeParse(parms[0]));
				return widget;
			} else if ("getStyleName".equals(mthodName)) {
				return widget.getStyleName();
			} else if ("getStylePrimaryName".equals(mthodName)) {
				return widget.getStylePrimaryName();
			} else if ("getWidth".equals(mthodName)) {
				return Util.getWidth(widget);
			} else if ("getHeight".equals(mthodName)) {
				return Util.getHeight(widget);
			} else if ("getTitle".equals(mthodName)) {
				return widget.getTitle();
			} else if (widget instanceof CellPanel
					&& "getSpacing".equals(mthodName)) {
				CellPanel cp = (CellPanel) widget;
				return new Integer(cp.getSpacing());
			} else if ("add".equals(mthodName) && widget instanceof HasWidgets
					&& parms.length == 1) {
				WidgetService ws = WidgetServiceFactory.getService(widget);
				return ws.addWidget((Widget) parms[0]);
			}
		} catch (RuntimeException e) {
			if (!DesignPanel.getInstance().isInCheckPoint()) {
				Window.alert(e.getMessage());
			}
		}
		return null;
	}

	public Object getParmObj(String parmStr) {
		if (parmStr.indexOf('.') != -1) {
			try {
				return new Float(parmStr);
			} catch (NumberFormatException e) {
			}
		}
		try {
			return new Integer(parmStr);
		} catch (NumberFormatException e) {
		}
		if ("true".equals(parmStr.trim())) {
			return new Boolean(true);
		}
		if ("false".equals(parmStr.trim())) {
			return new Boolean(false);
		}
		return parmStr.replaceAll("\"", "");
	}

	public String[] getProps() {
		return props;
	}

	public Ltext getLtext(String prop) {
		if (!Util.contains(getProps(), prop)) {
			return null;
		}
		Ltext lt = new Ltext(prop);
		WidgetService ws = WidgetServiceFactory.getService(this.widget);
		// Object o = ws.exec(Util.makeGetterName(prop), null);
		Object o = Util.doGetter(ws, prop);
		if (o == null) {
			return null;
		}
		if ("stylePrimaryName".equals(prop) || "styleName".equals(prop)) {
			MultiWordSuggestOracle so = new MultiWordSuggestOracle();
			so.addAll(DesignPanel.getInstance().getStyleNames());
			SuggestBox sb = new SuggestBox(so);
			lt.setTextBox(sb);
		}
		lt.setText(o.toString());
		return lt;
	}

	public void setLtext(String prop, Ltext ltext) {
		if (!Util.contains(getProps(), prop)) {
			return;
		}
		WidgetService ws = WidgetServiceFactory.getService(this.widget);
		ws.exec(Util.makeSetterName(prop), new Object[] { ltext.getValue() });
	}

	public Widget shallowCopy(Widget from) {
		DesignPanel dp = DesignPanel.getInstance();
		WidgetService wsf = WidgetServiceFactory.getService(from);
		WidgetService wst = WidgetServiceFactory.getService(this.widget);
		Iterator it = wsf.getInnerProps().iterator();
		while (it.hasNext()) {
			String prop = (String) it.next();
			// Object of = wsf.exec(Util.makeGetterName(prop), null);
			Object of = Util.doGetter(wsf, prop);
			wst.exec(Util.makeSetterName(prop), new Object[] { of });
			// 同じかCheck
			Object oc = dp.getCPMap1().get(from.getTitle() + prop);
			if (oc == null || !oc.equals(Util.nullSafe(of))) {
				dp.setCloneSame(false);
			}
			dp.getCPMap2().put(from.getTitle() + prop, Util.nullSafe(of));
		}
		return this.widget;
	}

	public String[] getInnerProps() {
		return getProps();
	}

	public boolean isAddable() {
		if (widget instanceof HasWidgets) {
			HasWidgets hw = (HasWidgets) widget;
			Label dummy = new Label();
			try {
				hw.add(dummy);
				hw.remove(dummy);
				return true;
			} catch (Exception e) {
			}
		}
		return false;
	}

	public boolean isAddableToParent() {
		if (parent instanceof HasWidgets) {
			return true;
		}
		return false;
	}

	public boolean isRemovableToParent() {
		return true;
	}

	public boolean isClickResize() {
		return true;
	}

}
