/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design.delegate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.DesignPanel;
import jp.co.kpscorp.gwt.client.design.Ltext;
import jp.co.kpscorp.gwt.client.design.Util;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.DockPanel.DockLayoutConstant;

public class DockPanelDelegate extends BaseDelegate {

	private Map dockLayoutMap = new HashMap();

	private Map dockLayoutMap2 = new HashMap();

	private String[] props = {};

	public DockPanelDelegate(Widget widget) {
		super();
		this.widget = widget;
		dockLayoutMap.put(DockPanel.CENTER, "CENTER");
		dockLayoutMap.put(DockPanel.EAST, "EAST");
		dockLayoutMap.put(DockPanel.NORTH, "NORTH");
		dockLayoutMap.put(DockPanel.SOUTH, "SOUTH");
		dockLayoutMap.put(DockPanel.WEST, "WEST");
		Iterator it = dockLayoutMap.keySet().iterator();
		while (it.hasNext()) {
			Object key = (Object) it.next();
			dockLayoutMap2.put(dockLayoutMap.get(key), key);
		}

	}

	public PopupPanel makeBar() {
		DesignPanel dp = DesignPanel.getInstance();
		MenuBar bar1 = new MenuBar(true);
		MenuBar bar11 = dp.getAddBar();
		MenuBar bar21 = new MenuBar(true);
		Iterator it = dockLayoutMap.keySet().iterator();
		while (it.hasNext()) {
			Object key = (Object) it.next();
			dockLayoutMap2.put(dockLayoutMap.get(key), key);
			bar21.addItem((String) dockLayoutMap.get(key), new ChangeTarget(
					(DockLayoutConstant) key));
		}
		bar1.addItem("add", bar11);
		bar1.addItem("changeTarget", bar21);
		bar1 = dp.addStandardBar(bar1, widget);
		PopupPanel pop = new PopupPanel(true);
		pop.add(bar1);
		return pop;
	}

	public void addWidget(Widget widget) {
		DockPanel dp = (DockPanel) this.widget;
		DockLayoutConstant con;
		if (this.targetInfo != null) {
			con = this.targetInfo;
			this.targetInfo = null;
		} else {
			con = (DockLayoutConstant) dockLayoutMap2.get(this.widget
					.getTitle());
		}
		if (con == null) {
			con = DockPanel.CENTER;
		}
		if (DockPanel.CENTER.equals(con)) {
			removeCenter(dp);
		}
		dp.add(widget, con);
		if (Util.findLabel(dp) != null && dp.getWidgetCount() > 1) {
			Util.removeLabel((HasWidgets) this.widget);
		}
	}

	public void removeWidget(Widget widget) {
		DockPanel dp = (DockPanel) this.widget;
		dp.remove(widget);
		if (!dp.iterator().hasNext()) {
			Label label = new Label("CENTER");
			label.setStyleName(BaseDelegate.lbstyle);
			widget.setTitle("CENTER");
			dp.add(label, DockPanel.CENTER);
		}
	}

	private void removeCenter(DockPanel dp) {
		Iterator it = dp.iterator();
		while (it.hasNext()) {
			Widget w = (Widget) it.next();
			if (DockPanel.CENTER.equals(dp.getWidgetDirection(w))) {
				dp.remove(w);
			}
		}
	}

	private class ChangeTarget implements Command {
		private DockPanel.DockLayoutConstant con;

		public ChangeTarget(DockLayoutConstant con) {
			super();
			this.con = con;
		}

		public void execute() {
			DockPanel dc = (DockPanel) widget;
			String s = (String) dockLayoutMap.get(con);
			Util.removeLabel(dc);
			Label label = new Label(s);
			label.setStyleName(BaseDelegate.lbstyle);
			try {
				dc.add(label, con);
			} catch (Exception e) {
			}
			dc.setTitle(s);
			DesignPanel.getInstance().getPop().hide();
		}
	}

	public Widget setInitStyle(Widget widget) {
		widget.setStyleName("design-newpanel");
		DockPanel dc = (DockPanel) widget;
		Util.setSpacing(dc, 10);
		Label label = new Label("CENTER");
		label.setStyleName(BaseDelegate.lbstyle);
		widget.setTitle("CENTER");
		dc.add(label, DockPanel.CENTER);
		return widget;

	}

	public String getAddCode(Widget widget, String parentFiledName,
			String fieldName) {
		DockPanel dc = (DockPanel) this.widget;
		DockPanel.DockLayoutConstant con = dc.getWidgetDirection(widget);
		String s = (String) dockLayoutMap.get(con);
		return parentFiledName + ".add(" + fieldName + ",DockPanel." + s + ");";
	}

	private DockPanel.DockLayoutConstant targetInfo = null;

	public void setTargetInfo(Widget parent, Widget child) {
		DockPanel dc = (DockPanel) parent;
		this.targetInfo = dc.getWidgetDirection(child);
	}

	public Object exec(String mthodName, Object[] parms) {
		if ("add".equals(mthodName) && parms.length == 2
				&& parms[0] instanceof Widget
				&& parms[1] instanceof DockPanel.DockLayoutConstant) {
			DockPanel dp = (DockPanel) this.widget;
			dp.add((Widget) parms[0], (DockPanel.DockLayoutConstant) parms[1]);
			return widget;
		}
		return null;
	}

	public Ltext getLtext(String prop) {
		return null;
	}

	public Object getParmObj(String parmStr) {
		int i = parmStr.indexOf("DockPanel.");
		if (i != -1) {
			return dockLayoutMap2.get(parmStr.substring(10));
		}
		return null;
	}

	public String[] getProps() {
		return props;
	}

	public void makeSetterCode(Widget widget, List[] lists, String fstr,
			String instr, String obstr, String fieldname, Map Map) {
	}

	public void setLtext(String prop, Ltext ltext) {
	}

}
