/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design.delegate;

import jp.co.kpscorp.gwt.client.design.Ltext;
import jp.co.kpscorp.gwt.client.design.Util;
import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;

public class HasHorizontalAlignmentDelegate extends BaseDelegate {

	protected HasHorizontalAlignment hh;

	protected String[] props = { "horizontalAlignment" };

	public static final HorizontalAlignmentConstant[] hacs = new HorizontalAlignmentConstant[] {
			null, HorizontalPanel.ALIGN_CENTER, HorizontalPanel.ALIGN_LEFT,
			HorizontalPanel.ALIGN_RIGHT };

	private ListBox select;

	public HasHorizontalAlignmentDelegate(Widget widget) {
		super();
		this.widget = widget;
		this.hh = (HasHorizontalAlignment) widget;
		select = getHACSelect();
	}

	public static ListBox getHACSelect() {
		ListBox select = new ListBox();
		for (int i = 0; i < hacs.length; i++) {
			String label = "";
			if (hacs[i] != null) {
				label = hacs[i].getTextAlignString();
			}
			select.addItem(label, i + "");
		}
		return select;
	}

	public Object exec(String mthodName, Object[] parms) {
		if ("setHorizontalAlignment".equals(mthodName)) {
			if (parms[0] != null) {
				hh
						.setHorizontalAlignment((HorizontalAlignmentConstant) parms[0]);
			}
			return hh;
		} else if ("getHorizontalAlignment".equals(mthodName)) {
			return hh.getHorizontalAlignment();
		}
		return null;
	}

	public Object getParmObj(String parmStr) {
		int i = parmStr.indexOf("ALIGN_");
		String s = parmStr.toUpperCase();
		if (i >= 0) {
			s = parmStr.substring(i + 6).toUpperCase();
		}
		for (int j = 0; j < hacs.length; j++) {
			HorizontalAlignmentConstant ha = hacs[j];
			if (ha != null && ha.getTextAlignString().toUpperCase().equals(s)) {
				return ha;
			}
		}
		return parmStr;
	}

	public String[] getProps() {
		return props;
	}

	public String makeParmString(Object o) {
		String s = super.makeParmString(o);
		if (o instanceof HorizontalAlignmentConstant) {
			HorizontalAlignmentConstant con = (HorizontalAlignmentConstant) o;
			return "HorizontalPanel.ALIGN_"
					+ con.getTextAlignString().toUpperCase();
		}
		return s;
	}

	public Ltext getLtext(String prop) {
		if ("horizontalAlignment".equals(prop)) {
			WidgetService ws = WidgetServiceFactory.getService(this.widget);
			Object o = ws.exec(Util.makeGetterName(prop), null);
			int i = Util.getIdex(hacs, o);
			select.setSelectedIndex(i);
			Ltext lt = new Ltext(prop);
			lt.setSelect(select);
			return lt;
		}
		return null;
	}

	public void setLtext(String prop, Ltext ltext) {
		if ("horizontalAlignment".equals(prop)) {
			int i = ltext.getSelect().getSelectedIndex();
			if (hacs[i] != null) {
				WidgetService ws = WidgetServiceFactory.getService(this.widget);
				ws.exec(Util.makeSetterName(prop), new Object[] { hacs[i] });
			}
		}
	}

}
