/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design.delegate;

import jp.co.kpscorp.gwt.client.design.WidgetService;

import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.Widget;

public class HasHtmlDelegate extends BaseDelegate {
	protected HasHTML ht;

	protected String[] props = { "HTML" };

	public HasHtmlDelegate(Widget widget, WidgetService service) {
		super();
		this.widget = widget;
		this.service = service;
		ht = (HasHTML) widget;
	}

	public Widget setInitStyle(Widget widget) {
		super.setInitStyle(widget);
		if (this.widget == null) {
			this.widget = widget;
			ht = (HasHTML) widget;
		}
		ht.setText(widget.getTitle());
		return widget;

	}

	public Object exec(String mthodName, Object[] parms) {
		if ("setHTML".equals(mthodName)) {
			ht.setHTML((String) parms[0]);
			return ht;
		} else if ("getHTML".equals(mthodName)) {
			return ht.getHTML();
		}
		return null;
	}

	public String[] getProps() {
		return props;
	}

}
