/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design.delegate;

import jp.co.kpscorp.gwt.client.design.WidgetService;

import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Widget;

public class HasTextDelegate extends BaseDelegate {

	protected HasText ht;

	protected String[] props = { "text" };

	public HasTextDelegate(Widget widget, WidgetService service) {
		super();
		this.widget = widget;
		this.service = service;
		ht = (HasText) widget;
	}

	public Widget setInitStyle(Widget widget) {
		super.setInitStyle(widget);
		if (this.widget == null) {
			this.widget = widget;
			ht = (HasText) widget;
		}
		ht.setText(widget.getTitle());
		return widget;

	}

	public Object exec(String mthodName, Object[] parms) {
		if ("setText".equals(mthodName)) {
			ht.setText((String) parms[0]);
			return ht;
		} else if ("getText".equals(mthodName)) {
			return ht.getText();
		}
		return null;
	}

	public String[] getProps() {
		return props;
	}

}
