/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design.delegate;

import jp.co.kpscorp.gwt.client.design.Ltext;
import jp.co.kpscorp.gwt.client.design.Util;
import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;

import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.HasVerticalAlignment.VerticalAlignmentConstant;

public class HasVerticalAlignmentDelegate extends BaseDelegate {

	protected HasVerticalAlignment va;

	protected String[] props = { "verticalAlignment" };

	public static final VerticalAlignmentConstant[] vacs = new VerticalAlignmentConstant[] {
			null, VerticalPanel.ALIGN_BOTTOM, VerticalPanel.ALIGN_MIDDLE,
			VerticalPanel.ALIGN_TOP };

	private ListBox select;

	public HasVerticalAlignmentDelegate(Widget widget) {
		super();
		this.widget = widget;
		this.va = (HasVerticalAlignment) widget;
		select = getVACSelect();
	}

	public static ListBox getVACSelect() {
		ListBox select = new ListBox();
		for (int i = 0; i < vacs.length; i++) {
			String label = "";
			if (vacs[i] != null) {
				label = vacs[i].getVerticalAlignString();
			}
			select.addItem(label, i + "");
		}
		return select;
	}

	public Object exec(String mthodName, Object[] parms) {
		if ("setVerticalAlignment".equals(mthodName)) {
			if (parms[0] != null) {
				va.setVerticalAlignment((VerticalAlignmentConstant) parms[0]);
			}
		} else if ("getVerticalAlignment".equals(mthodName)) {
			return va.getVerticalAlignment();
		}
		return null;
	}

	public Object getParmObj(String parmStr) {
		int i = parmStr.indexOf("ALIGN_");
		String s = parmStr;
		if (i >= 0) {
			s = parmStr.substring(i + 6).toUpperCase();
		}
		for (int j = 0; j < vacs.length; j++) {
			VerticalAlignmentConstant va = vacs[j];
			if (va != null
					&& va.getVerticalAlignString().toUpperCase().equals(s)) {
				return va;
			}
		}
		return parmStr;
	}

	public String[] getProps() {
		return props;
	}

	public Ltext getLtext(String prop) {
		if ("verticalAlignment".equals(prop)) {
			WidgetService ws = WidgetServiceFactory.getService(this.widget);
			Object o = ws.exec(Util.makeGetterName(prop), null);
			int i = Util.getIdex(vacs, o);
			select.setSelectedIndex(i);
			Ltext lt = new Ltext(prop);
			lt.setSelect(select);
			return lt;
		}
		return null;
	}

	public void setLtext(String prop, Ltext ltext) {
		if ("verticalAlignment".equals(prop)) {
			int i = ltext.getSelect().getSelectedIndex();
			if (vacs[i] != null) {
				WidgetService ws = WidgetServiceFactory.getService(this.widget);
				ws.exec(Util.makeSetterName(prop), new Object[] { vacs[i] });
			}
		}
	}

	public String makeParmString(Object o) {
		String s = super.makeParmString(o);
		if (o instanceof VerticalAlignmentConstant) {
			VerticalAlignmentConstant con = (VerticalAlignmentConstant) o;
			return "HorizontalPanel.ALIGN_"
					+ con.getVerticalAlignString().toUpperCase();
		}
		return s;
	}

}
