/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design.delegate;

import jp.co.kpscorp.gwt.client.design.WidgetService;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class ImageDelegate extends BaseDelegate {
	protected Image image;

	protected String[] props = { "url" };

	public ImageDelegate(Widget widget, WidgetService service) {
		super();
		this.widget = widget;
		this.service = service;
		image = (Image) widget;
	}

	public Widget setInitStyle(Widget widget) {
		super.setInitStyle(widget);
		if (this.widget == null) {
			this.widget = widget;
			image = (Image) widget;
		}
		widget.setStyleName("design-newpanel");
		widget.setHeight("50px");
		widget.setWidth("50px");
		image.setUrl("dog01.gif");
		return widget;

	}

	public Object exec(String mthodName, Object[] parms) {
		if ("setUrl".equals(mthodName)) {
			image.setUrl((String) parms[0]);
			return image;
		} else if ("getUrl".equals(mthodName)) {
			return image.getUrl();
		}
		return null;
	}

	public String[] getProps() {
		return props;
	}

}
