/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.gwt.client.design.delegate;

import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.CellFormaterPanel;
import jp.co.kpscorp.gwt.client.design.ColumnFormaterPanel;
import jp.co.kpscorp.gwt.client.design.DesignPanel;
import jp.co.kpscorp.gwt.client.design.RowColDialog;
import jp.co.kpscorp.gwt.client.design.RowFormaterPanel;
import jp.co.kpscorp.gwt.client.design.Util;
import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SourcesTableEvents;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.HTMLTable.CellFormatter;
import com.google.gwt.user.client.ui.HTMLTable.ColumnFormatter;
import com.google.gwt.user.client.ui.HTMLTable.RowFormatter;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.HasVerticalAlignment.VerticalAlignmentConstant;

public class TableDelegate extends BaseDelegate implements TableListener {

	private int row;

	private int col;

	private FlexTable table;

	private String[] props = { "cellSpacing", "cellPadding" };

	// private String[] rowprops = { "styleName", "stylePrimaryName",
	// "verticalAlign" };
	//
	// private String[] colprops = { "styleName", "stylePrimaryName", "width" };
	//
	// private String[] cellprops = { "styleName", "stylePrimaryName", "width",
	// "height", "verticalAlignment", "horizontalAlignment", "HTML" };

	private String[] rowprops = { "styleName", "verticalAlign" };

	private String[] colprops = { "styleName", "width" };

	private String[] cellprops = { "styleName", "width", "height",
			"verticalAlignment", "horizontalAlignment", "HTML" };

	private String[] formatters = { "rowFormatter", "columnFormatter",
			"cellFormatter" };

	private String[][] fmtProps = new String[][] { rowprops, colprops,
			cellprops };

	public TableDelegate(Widget widget) {
		super();
		this.widget = widget;
		this.table = (FlexTable) widget;
	}

	private String getterName(String s) {
		return "get" + className(s);
	}

	private String className(String s) {
		return s.substring(0, 1).toUpperCase() + s.substring(1);
	}

	public void addWidget(Widget widget) {
		table.setWidget(row, col, widget);
	}

	public String getAddCode(Widget widget, String parentFiledName,
			String fieldName) {
		int[] addr = getAddr(table, widget);
		return parentFiledName + ".setWidget(" + addr[0] + "," + addr[1] + ","
				+ fieldName + ");";
	}

	public void removeWidget(Widget widget) {
		int[] addr = getAddr(table, widget);
		int cellCnt = table.getCellCount(addr[0]);
		table.remove(widget);
		if (cellCnt - 1 == addr[1]) {
			Label label = new Label("ft" + addr[0]);
			label.setStyleName(BaseDelegate.lbstyle);
			table.setWidget(addr[0], addr[1], label);
		}

	}

	public Widget getInstance() {
		this.table = new FlexTable();
		if (!DesignPanel.getInstance().isInCheckPoint()) {
			RowColDialog dialog = new RowColDialog(table, 3, 3);
			dialog.center();
		}
		this.table.addTableListener(this);
		return this.table;
	}

	public void setClickEvent(Event event) {
		if (DOM.eventGetType(event) == Event.ONCLICK
				|| DOM.eventGetButton(event) == Event.BUTTON_RIGHT) {
			Element td = getEventTargetCell(event);
			if (td == null) {
				return;
			}
			Element tr = DOM.getParent(td);
			Element body = DOM.getParent(tr);
			row = DOM.getChildIndex(body, tr);
			col = DOM.getChildIndex(tr, td);
		}
	}

	protected Element getEventTargetCell(Event event) {
		Element parent = this.table.getElement();
		Element bodyElem = null;
		for (int i = 0; i < DOM.getChildCount(parent); i++) {
			Element child = DOM.getChild(parent, i);
			if (DOM.getElementProperty(child, "tagName").equalsIgnoreCase(
					"tbody")) {
				bodyElem = child;
			}
		}
		Element td = DOM.eventGetTarget(event);
		for (; td != null; td = DOM.getParent(td)) {
			// If it's a TD, it might be the one we're looking for.
			if (DOM.getElementProperty(td, "tagName").equalsIgnoreCase("td")) {
				// Make sure it's directly a part of this table before returning
				// it.
				Element tr = DOM.getParent(td);
				Element body = DOM.getParent(tr);
				if (DOM.compare(body, bodyElem)) {
					return td;
				}
			}
			// If we run into this table's body, we're out of options.
			if (DOM.compare(td, bodyElem)) {
				return null;
			}
		}
		return null;
	}

	public void setTargetInfo(Widget parent, Widget child) {
		FlexTable ft = (FlexTable) parent;
		int[] addr = getAddr(ft, child);
		this.row = addr[0];
		this.col = addr[1];
	}

	private int[] getAddr(FlexTable parent, Widget child) {
		for (int i = 0; i < parent.getRowCount(); i++) {
			for (int j = 0; j < parent.getCellCount(i); j++) {
				if (child == parent.getWidget(i, j)) {
					return new int[] { i, j };
				}
			}
		}
		return null;
	}

	public PopupPanel makeBar() {
		DesignPanel dp = DesignPanel.getInstance();
		MenuBar bar1 = new MenuBar(true);
		MenuBar bar11 = dp.getAddBar();
		bar1.addItem("add", bar11);
		bar1.addItem("resize", new Resize());
		bar1.addItem("rowFormater", new RowForm());
		bar1.addItem("columnFormater", new ColForm());
		bar1.addItem("cellFormater", new CellForm());
		bar1 = dp.addStandardBar(bar1, widget);
		PopupPanel pop = new PopupPanel(true);
		pop.add(bar1);
		return pop;
	}

	private class Resize implements Command {
		public void execute() {
			DesignPanel.getInstance().checkPoint();
			RowColDialog dialog = new RowColDialog(table, table.getRowCount(),
					table.getCellCount(table.getRowCount() - 1));
			dialog.center();
			DesignPanel.getInstance().getPop().hide();
		}
	}

	private class RowForm implements Command {
		public void execute() {
			Map map = DesignPanel.getInstance().getPropMap();
			String key = "TableDelegate_rf";
			RowFormaterPanel rf = (RowFormaterPanel) map.get(key);
			if (rf != null) {
				rf.hide();
			}
			rf = new RowFormaterPanel(table);
			rf.show();
			map.put(key, rf);
			DesignPanel.getInstance().getPop().hide();
		}
	}

	private class ColForm implements Command {
		public void execute() {
			Map map = DesignPanel.getInstance().getPropMap();
			String key = "TableDelegate_cf";
			ColumnFormaterPanel cf = (ColumnFormaterPanel) map.get(key);
			if (cf != null) {
				cf.hide();
			}
			cf = new ColumnFormaterPanel(table);
			cf.show();
			map.put(key, cf);
			DesignPanel.getInstance().getPop().hide();
		}
	}

	private class CellForm implements Command {
		public void execute() {
			Map map = DesignPanel.getInstance().getPropMap();
			String key = "TableDelegate_cef";
			CellFormaterPanel cef = (CellFormaterPanel) map.get(key);
			if (cef != null) {
				cef.hide();
			}
			cef = new CellFormaterPanel(table);
			cef.show();
			map.put(key, cef);
			DesignPanel.getInstance().getPop().hide();
		}
	}

	public void onCellClicked(SourcesTableEvents sender, int row, int cell) {
	}

	public Object exec(String mthodName, Object[] parms) {
		if ("setHTML".equals(mthodName) || "getHTML".equals(mthodName)) {
			exec(mthodName + getterName(formatters[2]), parms);
		}
		try {
			if ("setCellSpacing".equals(mthodName)) {
				table.setCellSpacing(Util.safeParse(parms[0]));
				return table;
			} else if ("setCellPadding".equals(mthodName)) {
				table.setCellPadding(Util.safeParse(parms[0]));
				return table;
			} else if ("getCellSpacing".equals(mthodName)) {
				return new Integer(table.getCellSpacing());
			} else if ("getCellPadding".equals(mthodName)) {
				return new Integer(table.getCellPadding());
			} else if ("setWidget".equals(mthodName) && parms.length == 3
					&& parms[0] instanceof String && parms[1] instanceof String
					&& parms[2] instanceof Widget) {
				table.setWidget(Integer.parseInt((String) parms[0]), Integer
						.parseInt((String) parms[1]), (Widget) parms[2]);
				return widget;
			}
			Object o = execRowFormater(mthodName, parms);
			if (o != null) {
				return o;
			}
			o = execColumnFormatter(mthodName, parms);
			if (o != null) {
				return o;
			}
			o = execCellFormatter(mthodName, parms);
			if (o != null) {
				return o;
			}
		} catch (Exception e) {
			Window.alert(e.getMessage());
		}
		return null;

	}

	private Object execRowFormater(String mthodName, Object[] parms) {
		String suf = "getRowFormatter";
		RowFormatter rf = table.getRowFormatter();
		if (!mthodName.endsWith(suf)) {
			return null;
		}
		mthodName = mthodName.substring(0, mthodName.length() - suf.length());
		if ("setStyleName".equals(mthodName)) {
			rf.setStyleName(Integer.parseInt((String) parms[0]),
					(String) parms[1]);
			return table;
		} else if ("setStylePrimaryName".equals(mthodName)) {
			// StylePrimaryNameはブランクをセットしない
			if (parms[1] != null && !"".equals(((String) parms[1]))) {
				rf.setStyleName(Integer.parseInt((String) parms[0]),
						(String) parms[1]);
			}
			return table;
		} else if ("setVerticalAlign".equals(mthodName)) {
			if (parms[1] != null) {
				rf.setVerticalAlign(Integer.parseInt((String) parms[0]),
						(VerticalAlignmentConstant) parms[1]);
			}
			return table;
		} else if ("getStyleName".equals(mthodName)) {
			return rf.getStyleName(Integer.parseInt((String) parms[0]));
		} else if ("getStylePrimaryName".equals(mthodName)) {
			return rf.getStyleName(Integer.parseInt((String) parms[0]));
		} else if ("getVerticalAlign".equals(mthodName)) {
			return Util.getVerticalAlign(rf.getElement(Integer
					.parseInt((String) parms[0])));
		}
		return null;
	}

	private Object execColumnFormatter(String mthodName, Object[] parms) {
		String suf = "getColumnFormatter";
		ColumnFormatter cf = table.getColumnFormatter();
		if (!mthodName.endsWith(suf)) {
			return null;
		}
		mthodName = mthodName.substring(0, mthodName.length() - suf.length());
		if ("setStyleName".equals(mthodName)) {
			cf.setStyleName(Integer.parseInt((String) parms[0]),
					(String) parms[1]);
			return table;
		} else if ("setStylePrimaryName".equals(mthodName)) {
			// StylePrimaryNamegeはブランクをセットしない
			if (parms[1] != null && !"".equals(((String) parms[1]))) {
				cf.setStyleName(Integer.parseInt((String) parms[0]),
						(String) parms[1]);
			}
			return table;
		} else if ("setWidth".equals(mthodName)) {
			cf.setWidth(Integer.parseInt((String) parms[0]), (String) parms[1]);
			return table;
		} else if ("getStyleName".equals(mthodName)) {
			return cf.getStyleName(Integer.parseInt((String) parms[0]));
		} else if ("getStylePrimaryName".equals(mthodName)) {
			return cf.getStyleName(Integer.parseInt((String) parms[0]));
		} else if ("getWidth".equals(mthodName)) {
			Element e = getColElement(Integer.parseInt((String) parms[0]));
			if (e != null) {
				return DOM.getElementProperty(e, "width");
			} else {
				return "";
			}
		}
		return null;
	}

	private Object execCellFormatter(String mthodName, Object[] parms) {
		String suf = "getCellFormatter";
		CellFormatter cf = table.getCellFormatter();
		if (!mthodName.endsWith(suf)) {
			return null;
		}
		mthodName = mthodName.substring(0, mthodName.length() - suf.length());
		if ("setStyleName".equals(mthodName)) {
			cf.setStyleName(Integer.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1]), (String) parms[2]);
			return table;
		} else if ("setStylePrimaryName".equals(mthodName)) {
			// StylePrimaryNameはブランクをセットしない
			if (parms[2] != null && !"".equals(((String) parms[2]))) {
				cf.setStyleName(Integer.parseInt((String) parms[0]), Integer
						.parseInt((String) parms[1]), (String) parms[2]);
			}
			return table;
		} else if ("setVerticalAlignment".equals(mthodName)) {
			if (parms[2] != null) {
				cf.setVerticalAlignment(Integer.parseInt((String) parms[0]),
						Integer.parseInt((String) parms[1]),
						(VerticalAlignmentConstant) parms[2]);
			}
			return table;
		} else if ("setHorizontalAlignment".equals(mthodName)) {
			if (parms[2] != null) {
				cf.setHorizontalAlignment(Integer.parseInt((String) parms[0]),
						Integer.parseInt((String) parms[1]),
						(HorizontalAlignmentConstant) parms[2]);
			}
			return table;
		} else if ("setWidth".equals(mthodName)) {
			cf.setWidth(Integer.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1]), (String) parms[2]);
			return table;
		} else if ("setHeight".equals(mthodName)) {
			cf.setHeight(Integer.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1]), (String) parms[2]);
			return table;
		} else if ("setHTML".equals(mthodName)) {
			if (!Util.isWidget(table, Integer.parseInt((String) parms[0]),
					Integer.parseInt((String) parms[1]))) {
				// widgetがある場合は上書きしない
				table.setHTML(Integer.parseInt((String) parms[0]), Integer
						.parseInt((String) parms[1]), (String) parms[2]);
			}
			return table;
		} else if ("getStyleName".equals(mthodName)) {
			return cf.getStyleName(Integer.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1]));
		} else if ("getStylePrimaryName".equals(mthodName)) {
			return cf.getStyleName(Integer.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1]));
		} else if ("getVerticalAlignment".equals(mthodName)) {
			return Util.getVerticalAlign(cf.getElement(Integer
					.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1])));
		} else if ("getHorizontalAlignment".equals(mthodName)) {
			HasHorizontalAlignmentDelegate del = new HasHorizontalAlignmentDelegate(
					null);
			return del.getParmObj(DOM.getElementProperty(cf.getElement(Integer
					.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1])), "align"));
		} else if ("getWidth".equals(mthodName)) {
			return DOM.getElementProperty(cf.getElement(Integer
					.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1])), "width");
		} else if ("getHeight".equals(mthodName)) {
			return DOM.getElementProperty(cf.getElement(Integer
					.parseInt((String) parms[0]), Integer
					.parseInt((String) parms[1])), "height");
		} else if ("getHTML".equals(mthodName)) {
			String s = table.getHTML(Integer.parseInt((String) parms[0]),
					Integer.parseInt((String) parms[1]));
			if (s.indexOf("widgetID") == -1) {
				// widgetはHTMLとして扱わない
				return s;
			}
		}
		return null;
	}

	private Element getColElement(int i) {
		Element parent = null;
		for (int j = 0; j < DOM.getChildCount(table.getElement()); j++) {
			Element e = DOM.getChild(table.getElement(), j);
			if (e.toString().toUpperCase().indexOf("COLGROUP") != -1) {
				parent = e;
				break;
			}
		}
		if (parent != null) {
			return DOM.getChild(parent, i);
		}
		return null;
	}

	public Object getParmObj(String parmStr) {
		HasHorizontalAlignmentDelegate delegate1 = new HasHorizontalAlignmentDelegate(
				null);
		HasVerticalAlignmentDelegate delegate2 = new HasVerticalAlignmentDelegate(
				null);
		Object o = delegate1.getParmObj(parmStr);
		if (o == parmStr) {
			o = delegate2.getParmObj(parmStr);
		}
		return o;
	}

	public String[] getProps() {
		return props;
	}

	public Widget setInitStyle(Widget widget) {
		super.setInitStyle(widget);
		widget.setStyleName("design-table");
		return widget;
	}

	public String makeParmString(Object o) {
		HasHorizontalAlignmentDelegate delegate1 = new HasHorizontalAlignmentDelegate(
				null);
		HasVerticalAlignmentDelegate delegate2 = new HasVerticalAlignmentDelegate(
				null);
		String s = delegate1.makeParmString(o);
		if (s == null) {
			s = delegate2.makeParmString(o);
		}
		return s;
	}

	public void makeSetterCode(Widget widget, List[] lists, String fstr,
			String instr, String obstr, String fn, Map map) {
		super.makeSetterCode(widget, lists, fstr, instr, obstr, fn, map);
		for (int k = 0; k < formatters.length; k++) {
			String fmt = formatters[k];
			String declear = className(fmt) + " " + fmt + ";";
			if (!lists[0].contains(declear)) {
				lists[0].add(declear);
			}
			lists[1].add(fmt + " = " + fn + "." + getterName(fmt) + "();");
			for (int i = 0; i < getCount(k); i++) {
				for (int j = 0; j < getProps(k).length; j++) {
					String prop = getProps(k)[j];
					setSetterCode(lists[1], fmt, i, prop, fn);
				}
			}
		}
	}

	private void setSetterCode(List list, String fmt, int i, String prop,
			String fn) {
		String s = makeParmString(getByCnt(prop, i));
		if (prop.indexOf("CellFormatter") == -1) {
			if (s != null && !"\"\"".equals(s) && !"".equals(s)) {
				list.add(fmt + "."
						+ Util.makeSetterName(getSimplePropName(prop)) + "("
						+ i + "," + s + ");");
			}
		} else {
			int[] addr = makeAddrByCnt(i);
			if (s != null && !"\"\"".equals(s) && !"".equals(s)) {
				// setTextのみfnにセット
				if ("text".equals(getSimplePropName(prop))) {
					fmt = fn;
				}
				list.add(fmt + "."
						+ Util.makeSetterName(getSimplePropName(prop)) + "("
						+ addr[0] + "," + addr[1] + "," + s + ");");
			}

		}
	}

	public int[] makeAddrByCnt(int i) {
		int[] addr = new int[2];
		addr[0] = i / table.getCellCount(0);
		addr[1] = i % table.getCellCount(0);
		return addr;
	}

	public int getCount(int key) {
		switch (key) {
		case 0:
			return table.getRowCount();
		case 1:
			return table.getCellCount(0);
		default:
			return table.getCellCount(0) * table.getRowCount();
		}
	}

	public String[] getProps(int i) {
		String[] ss = new String[fmtProps[i].length];
		for (int j = 0; j < ss.length; j++) {
			ss[j] = fmtProps[i][j] + getterName(formatters[i]);
		}
		return ss;
	}

	public String getSimplePropName(String prop) {
		for (int i = 0; i < formatters.length; i++) {
			String s = getterName(formatters[i]);
			if (prop.endsWith(s)) {
				return prop.substring(0, prop.length() - s.length());
			}
		}
		return prop;
	}

	public Object getByCnt(String prop, int i) {
		if (prop.indexOf("CellFormatter") == -1) {
			return exec(Util.makeGetterName(prop), new Object[] { i + "" });
		} else {
			int[] addr = makeAddrByCnt(i);
			if (table.getCellCount(addr[0]) > addr[1]) {
				return exec(Util.makeGetterName(prop), new Object[] {
						addr[0] + "", addr[1] + "" });
			} else {
				return null;
			}
		}
	}

	public Object setByCnt(String prop, int i, Object o) {
		if (prop.indexOf("CellFormatter") == -1) {
			return exec(Util.makeSetterName(prop), new Object[] { i + "", o });
		} else {
			int[] addr = makeAddrByCnt(i);
			return exec(Util.makeSetterName(prop), new Object[] { addr[0] + "",
					addr[1] + "", o });
		}
	}

	public String getClassName(int i) {
		return className(formatters[i]);
	}

	public int[] getClikedAddr() {
		return new int[] { row, col };
	}

	public Widget shallowCopy(Widget from) {
		if (from instanceof FlexTable) {
			DesignPanel dp = DesignPanel.getInstance();
			FlexTable ft = (FlexTable) from;
			// cell コピー
			for (int row = 0; row < ft.getRowCount(); row++) {
				for (int column = 0; column < ft.getCellCount(row); column++) {
					Widget w = ft.getWidget(row, column);
					// 同じかCheck
					Object oc = dp.getCPMap1().get(
							from.getTitle() + row + column);
					if (oc == null) {
						dp.setCloneSame(false);
						oc = "";
					}
					if (w != null) {
						WidgetService ws = WidgetServiceFactory.getService(w);
						table.setWidget(row, column, ws.getClone());
					} else {
						table.setHTML(row, column, ft.getHTML(row, column));
						if (!oc.equals(Util.nullSafe(ft.getHTML(row, column)))) {
							dp.setCloneSame(false);
						}
						dp.getCPMap2().put(from.getTitle() + row + column,
								Util.nullSafe(ft.getHTML(row, column)));
					}
				}
			}
			super.shallowCopy(from);
			// formatter コピー
			TableDelegate ftd = new TableDelegate(ft);
			for (int k = 0; k < formatters.length; k++) {
				for (int j = 0; j < getCount(k); j++) {
					for (int i = 0; i < rowprops.length; i++) {
						String prop = rowprops[i]
								+ Util.makeGetterName(formatters[k]);
						Object of = ftd.getByCnt(prop, j);
						setByCnt(prop, j, of);
						// 同じかCheck
						Object oc = dp.getCPMap1().get(
								from.getTitle() + prop + j);
						if (oc == null || !oc.equals(Util.nullSafe(of))) {
							dp.setCloneSame(false);
						}
						dp.getCPMap2().put(from.getTitle() + prop + j,
								Util.nullSafe(of));
					}
				}
			}
		}
		return this.table;
	}
}
