package jp.co.kpscorp.gwt.client.resize;

import com.google.gwt.user.client.*;
import com.google.gwt.user.client.ui.*;

public class ResizableWindow extends Composite {
  private RootWindow root;
  private FlexTable table = new FlexTable();
  private ResizingImage resizingImage = new ResizingImage();

  /**
   * 暗黙的スーパー・コンストラクター
   */
  public ResizableWindow() {
	super();
  }

  public ResizableWindow(RootWindow root) {
    this.root = root;

    table.setHTML(0, 0, "");
    table.setHTML(0, 1, "");
    table.setHTML(0, 2, "");
    table.setHTML(1, 0, "");
    table.setHTML(1, 1, "");
    table.setHTML(1, 2, "");
    table.setHTML(2, 0, "");
    table.setHTML(2, 1, "");
    table.setHTML(2, 2, "");

    table.setCellSpacing (0);
    table.setCellPadding (0);
    table.getCellFormatter().addStyleName(0, 0, "lodgon-ResizeWindowTopLeft");
    table.getCellFormatter().addStyleName(0, 2, "lodgon-ResizeWindowTopRight");
    table.getCellFormatter().addStyleName(2, 0, "lodgon-ResizeWindowBotLeft");
    table.getCellFormatter().addStyleName(2, 2, "lodgon-ResizeWindowBotRight");
    table.getCellFormatter().addStyleName(0, 1, "lodgon-ResizeWindowTop");
    table.getCellFormatter().addStyleName(1, 0, "lodgon-ResizeWindowLeft");
    table.getCellFormatter().addStyleName(1, 2, "lodgon-ResizeWindowRight");
    table.getCellFormatter().addStyleName(2, 1, "lodgon-ResizeWindowBot");
    table.getCellFormatter().addStyleName(1, 1, "lodgon-ResizeWindowInner");

    table.getCellFormatter().setVerticalAlignment(1, 1, HasVerticalAlignment.ALIGN_TOP);

    table.insertRow(2);
    table.setHTML(2, 0, "");
    table.setHTML(2, 1, "");
    table.setHTML(2, 2, "");

    resizingImage.addStyleName("lodgon-ResizeWindowImage");

    FlexTable resizingTable = new FlexTable();
    resizingTable.setCellSpacing(0);
    resizingTable.setWidth("100%");
    resizingTable.setHTML(0, 0, "");
    resizingTable.setWidget(0, 1, resizingImage);
    resizingTable.getCellFormatter().setWidth(0, 1, "10px");
    resizingTable.getCellFormatter().setHeight(0, 1, "10px");

    table.setWidget(2, 1, resizingTable);
    DOM.setStyleAttribute(table.getRowFormatter().getElement(2), "height", "16px");

    table.getCellFormatter().addStyleName(2, 0, "lodgon-ResizeWindowLeft");
    table.getCellFormatter().addStyleName(2, 1, "lodgon-ResizeWindowInner");
    table.getCellFormatter().addStyleName(2, 2, "lodgon-ResizeWindowRight");

    setWidget(table);
  }

  public void setContent(Widget w) {
    table.setWidget(1, 1, w);
  }

  public void setPixelSize(int width, int height) {
    table.setWidth(width + "px");
    table.setHeight(height + "px");
  }

  /**
   * The resizing happens by using the amount of pixels the mouse has
   * moved since resizing started. The dimensions of this window are
   * adjusted by the difference of the mouse position.
   */
  public void resize(Event e) {
    int xDiff = DOM.eventGetClientX(e) - resizingImage.dragStartX;
    int yDiff = DOM.eventGetClientY(e) - resizingImage.dragStartY;

    if ((resizingImage.initialWidth + xDiff) < 150) {
      xDiff = 150 - resizingImage.initialWidth;
    }
    if ((resizingImage.initialHeight + yDiff) < 100) {
      yDiff = 100 - resizingImage.initialHeight;
    }

    table.setWidth((resizingImage.initialWidth + xDiff) + "px");
    table.setHeight((resizingImage.initialHeight + yDiff) + "px");
  }

  public int getResizableWindowWidth() {
    return this.getOffsetWidth();
  }

  public int getResizableWindowHeight() {
    return this.getOffsetHeight();
  }

  /**
   * The label handling the onmousedown logic. This is a Label instead of an
   * image to avoid the image drag&drop behaviour of the browsers.
   */
  private class ResizingImage extends Label {
    private int dragStartX;
    private int dragStartY;

    private int initialWidth;
    private int initialHeight;

    public ResizingImage() {
      setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);

      // listen for MOUSE DOWN events
      sinkEvents(Event.ONMOUSEDOWN);
    }

    public void onBrowserEvent(Event e) {
      Element target = DOM.eventGetTarget(e);
      if (target.equals(this.getElement())) {
        if (Event.ONMOUSEDOWN == DOM.eventGetType(e)) {
          // set start position of the mouse
          dragStartX = DOM.eventGetClientX(e);
          dragStartY = DOM.eventGetClientY(e);

          // remember initial window dimensions
          initialWidth = getResizableWindowWidth();
          initialHeight = getResizableWindowHeight();

          // let the root window know we started resizing this window
          root.setResizingWindow(ResizableWindow.this);
        }
      }
    }
  }
}
